/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.geometry;

import java.util.Arrays;
import shadow.org.elasticsearch.geometry.Geometry;
import shadow.org.elasticsearch.geometry.GeometryVisitor;
import shadow.org.elasticsearch.geometry.ShapeType;
import shadow.org.elasticsearch.geometry.utils.WellKnownText;

public class Line
implements Geometry {
    public static final Line EMPTY = new Line();
    private final double[] y;
    private final double[] x;
    private final double[] z;

    protected Line() {
        this.y = new double[0];
        this.x = new double[0];
        this.z = null;
    }

    public Line(double[] x, double[] y) {
        this(x, y, null);
    }

    public Line(double[] x, double[] y, double[] z) {
        this.y = y;
        this.x = x;
        this.z = z;
        if (y == null) {
            throw new IllegalArgumentException("y must not be null");
        }
        if (x == null) {
            throw new IllegalArgumentException("x must not be null");
        }
        if (y.length != x.length) {
            throw new IllegalArgumentException("x and y must be equal length");
        }
        if (y.length < 2) {
            throw new IllegalArgumentException("at least two points in the line is required");
        }
        if (z != null && z.length != x.length) {
            throw new IllegalArgumentException("z and x must be equal length");
        }
    }

    public int length() {
        return this.y.length;
    }

    public double getY(int i) {
        return this.y[i];
    }

    public double getX(int i) {
        return this.x[i];
    }

    public double getZ(int i) {
        if (this.z != null) {
            return this.z[i];
        }
        return Double.NaN;
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double[] getZ() {
        return this.z == null ? null : (double[])this.z.clone();
    }

    public double getLat(int i) {
        return this.y[i];
    }

    public double getLon(int i) {
        return this.x[i];
    }

    public double getAlt(int i) {
        if (this.z != null) {
            return this.z[i];
        }
        return Double.NaN;
    }

    public double[] getLats() {
        return (double[])this.y.clone();
    }

    public double[] getLons() {
        return (double[])this.x.clone();
    }

    public double[] getAlts() {
        return this.z == null ? null : (double[])this.z.clone();
    }

    @Override
    public ShapeType type() {
        return ShapeType.LINESTRING;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.y.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line line = (Line)o;
        return Arrays.equals(this.y, line.y) && Arrays.equals(this.x, line.x) && Arrays.equals(this.z, line.z);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.y);
        result = 31 * result + Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.z);
        return result;
    }

    @Override
    public boolean hasZ() {
        return this.z != null;
    }

    public String toString() {
        return WellKnownText.toWKT(this);
    }
}

