/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FetchResponse;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.SqlResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractWireOperations
implements FbWireOperations {
    private static final Logger log = LoggerFactory.getLogger(AbstractWireOperations.class);
    private final WireConnection<?, ?> connection;
    private final WarningMessageCallback defaultWarningMessageCallback;
    private final Object syncObject;

    protected AbstractWireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback, Object syncObject) {
        this.connection = connection;
        this.defaultWarningMessageCallback = defaultWarningMessageCallback;
        this.syncObject = syncObject;
    }

    @Override
    public final XdrStreamAccess getXdrStreamAccess() {
        return this.connection.getXdrStreamAccess();
    }

    protected final Encoding getEncoding() {
        return this.connection.getEncoding();
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SQLException readStatusVector() throws SQLException {
        boolean debug = log.isDebugEnabled();
        FbExceptionBuilder builder = new FbExceptionBuilder();
        XdrInputStream xdrIn = this.getXdrIn();
        try {
            block10: while (true) {
                int arg = xdrIn.readInt();
                switch (arg) {
                    case 1: {
                        int errorCode = xdrIn.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_gds int: " + errorCode);
                        }
                        if (errorCode == 0) continue block10;
                        builder.exception(errorCode);
                        continue block10;
                    }
                    case 18: {
                        int errorCode = xdrIn.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_warning int: " + errorCode);
                        }
                        if (errorCode == 0) continue block10;
                        builder.warning(errorCode);
                        continue block10;
                    }
                    case 2: 
                    case 5: {
                        String stringValue = xdrIn.readString(this.getEncoding());
                        if (debug) {
                            log.debug("readStatusVector string: " + stringValue);
                        }
                        builder.messageParameter(stringValue);
                        continue block10;
                    }
                    case 19: {
                        String sqlState = xdrIn.readString(this.getEncoding());
                        if (debug) {
                            log.debug("readStatusVector sqlstate: " + sqlState);
                        }
                        builder.sqlState(sqlState);
                        continue block10;
                    }
                    case 4: {
                        int intValue = xdrIn.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_number int: " + intValue);
                        }
                        builder.messageParameter(intValue);
                        continue block10;
                    }
                    case 0: {
                        if (builder.isEmpty()) {
                            return null;
                        }
                        return builder.toFlatSQLException();
                    }
                }
                int e = xdrIn.readInt();
                if (debug) {
                    log.debug("readStatusVector arg: " + arg + " int: " + e);
                }
                builder.messageParameter(e);
            }
        }
        catch (IOException ioe) {
            throw new FbExceptionBuilder().exception(335544726).cause(ioe).toSQLException();
        }
    }

    @Override
    public final Response readResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        Response response = this.readSingleResponse(warningCallback);
        this.processResponse(response);
        return response;
    }

    @Override
    public final Response readOperationResponse(int operationCode, WarningMessageCallback warningCallback) throws SQLException, IOException {
        Response response = this.processOperation(operationCode);
        this.processResponseWarnings(response, warningCallback);
        this.processResponse(response);
        return response;
    }

    @Override
    public final Response readSingleResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        Response response = this.processOperation(this.readNextOperation());
        this.processResponseWarnings(response, warningCallback);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readNextOperation() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.processDeferredActions();
            return this.connection.readNextOperation();
        }
    }

    protected final Response processOperation(int operation) throws SQLException, IOException {
        XdrInputStream xdrIn = this.getXdrIn();
        switch (operation) {
            case 9: {
                return new GenericResponse(xdrIn.readInt(), xdrIn.readLong(), xdrIn.readBuffer(), this.readStatusVector());
            }
            case 66: {
                return new FetchResponse(xdrIn.readInt(), xdrIn.readInt());
            }
            case 78: {
                return new SqlResponse(xdrIn.readInt());
            }
        }
        throw new FbExceptionBuilder().nonTransientException(337248276).messageParameter(operation).messageParameter("processOperation").toFlatSQLException();
    }

    @Override
    public final void processResponse(Response response) throws SQLException {
        GenericResponse genericResponse;
        SQLException exception;
        if (response instanceof GenericResponse && (exception = (genericResponse = (GenericResponse)response).getException()) != null && !(exception instanceof SQLWarning)) {
            throw exception;
        }
    }

    @Override
    public final void processResponseWarnings(Response response, WarningMessageCallback warningCallback) {
        GenericResponse genericResponse;
        SQLException exception;
        if (warningCallback == null) {
            warningCallback = this.defaultWarningMessageCallback;
        }
        if (response instanceof GenericResponse && (exception = (genericResponse = (GenericResponse)response).getException()) != null && exception instanceof SQLWarning) {
            warningCallback.processWarning((SQLWarning)exception);
        }
    }

    @Override
    public final GenericResponse readGenericResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return (GenericResponse)this.readResponse(warningCallback);
    }

    @Override
    public final SqlResponse readSqlResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return (SqlResponse)this.readResponse(warningCallback);
    }

    @Override
    public final void consumePackets(int numberOfResponses, WarningMessageCallback warningCallback) {
        while (numberOfResponses > 0) {
            --numberOfResponses;
            try {
                this.readResponse(warningCallback);
            }
            catch (Exception e) {
                warningCallback.processWarning(new SQLWarning(e));
                log.warn("Exception in consumePackets", e);
            }
        }
    }

    @Override
    public final void writeDirect(byte[] data) throws IOException {
        this.connection.writeDirect(data);
    }

    protected final Object getSynchronizationObject() {
        return this.syncObject;
    }

    protected final void addServerKeys(byte[] serverKeys) throws SQLException {
        this.connection.addServerKeys(serverKeys);
    }

    protected final void clearServerKeys() {
        this.connection.clearServerKeys();
    }

    protected final ClientAuthBlock getClientAuthBlock() {
        return this.connection.getClientAuthBlock();
    }

    protected final IAttachProperties<?> getAttachProperties() {
        return this.connection.getAttachProperties().asImmutable();
    }

    protected final List<EncryptionIdentifier> getEncryptionIdentifiers() {
        return this.connection.getEncryptionIdentifiers();
    }

    protected final WireConnection<?, ?> getConnection() {
        return this.connection;
    }

    protected final WarningMessageCallback getDefaultWarningMessageCallback() {
        return this.defaultWarningMessageCallback;
    }
}

