/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.LibCHelper;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.Target_java_lang_ProcessEnvironment_StringEnvironment;
import com.oracle.svm.core.posix.Target_java_lang_ProcessEnvironment_Value;
import com.oracle.svm.core.posix.Target_java_lang_ProcessEnvironment_Variable;
import com.oracle.svm.core.util.PointerUtils;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;

@TargetClass(className="java.lang.ProcessEnvironment")
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
final class Target_java_lang_ProcessEnvironment {
    @Alias
    @InjectAccessors(value=EnvironmentAccessor.class)
    private static HashMap<Target_java_lang_ProcessEnvironment_Variable, Target_java_lang_ProcessEnvironment_Value> theEnvironment;
    @Alias
    @InjectAccessors(value=EnvironmentAccessor.class)
    private static Map<String, String> theUnmodifiableEnvironment;

    Target_java_lang_ProcessEnvironment() {
    }

    @Substitute
    static byte[][] environ() {
        CCharPointerPointer environ = LibCHelper.getEnviron();
        int count = 0;
        int i = 0;
        while (environ.read(i).isNonNull()) {
            if (SubstrateUtil.strchr(environ.read(i), 61).isNonNull()) {
                ++count;
            }
            ++i;
        }
        byte[][] result = new byte[count * 2][];
        int j = 0;
        int i2 = 0;
        while (environ.read(i2).isNonNull()) {
            CCharPointer varBeg = environ.read(i2);
            CCharPointer varEnd = SubstrateUtil.strchr(varBeg, 61);
            if (varEnd.isNonNull()) {
                CCharPointer valBeg = varEnd.addressOf(1);
                int varLength = (int)PointerUtils.absoluteDifference((PointerBase)varEnd, (PointerBase)varBeg).rawValue();
                int valLength = (int)SubstrateUtil.strlen(valBeg).rawValue();
                byte[] var = new byte[varLength];
                CTypeConversion.asByteBuffer((PointerBase)varBeg, (int)varLength).get(var);
                result[2 * j] = var;
                byte[] val = new byte[valLength];
                CTypeConversion.asByteBuffer((PointerBase)valBeg, (int)valLength).get(val);
                result[2 * j + 1] = val;
                ++j;
            }
            ++i2;
        }
        assert (j == count);
        return result;
    }

    static class EnvironmentAccessor {
        private static HashMap<Target_java_lang_ProcessEnvironment_Variable, Target_java_lang_ProcessEnvironment_Value> theEnvironment;
        private static Map<String, String> theUnmodifiableEnvironment;

        EnvironmentAccessor() {
        }

        static HashMap<Target_java_lang_ProcessEnvironment_Variable, Target_java_lang_ProcessEnvironment_Value> getTheEnvironment() {
            EnvironmentAccessor.ensureInitialized();
            return theEnvironment;
        }

        static Map<String, String> getTheUnmodifiableEnvironment() {
            EnvironmentAccessor.ensureInitialized();
            return theUnmodifiableEnvironment;
        }

        static void ensureInitialized() {
            if (theUnmodifiableEnvironment == null) {
                byte[][] environ = Target_java_lang_ProcessEnvironment.environ();
                HashMap<Target_java_lang_ProcessEnvironment_Variable, Target_java_lang_ProcessEnvironment_Value> env = new HashMap<Target_java_lang_ProcessEnvironment_Variable, Target_java_lang_ProcessEnvironment_Value>(environ.length / 2 + 3);
                for (int i = environ.length - 1; i > 0; i -= 2) {
                    byte[] var = environ[i - 1];
                    byte[] val = environ[i];
                    env.put(Target_java_lang_ProcessEnvironment_Variable.valueOf(var), Target_java_lang_ProcessEnvironment_Value.valueOf(val));
                }
                theEnvironment = env;
                theUnmodifiableEnvironment = SubstrateUtil.cast(new Target_java_lang_ProcessEnvironment_StringEnvironment(env), Map.class);
            }
        }
    }
}

