/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KonanCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt;
import org.jetbrains.kotlin.gradle.dsl.NativeCacheKind;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBinary;
import org.jetbrains.kotlin.gradle.tasks.CacheBuilder;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImplKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0/J\u0010\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u000202H\u0002J2\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001c2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\"072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001c09H\u0002J\b\u0010:\u001a\u000204H\u0002J\u001e\u0010;\u001a\u0002042\u0006\u00101\u001a\u0002022\f\u0010<\u001a\b\u0012\u0004\u0012\u00020209H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u0002020>2\u0006\u00101\u001a\u000202H\u0002J\u0010\u0010?\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0002J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u001cH\u0002J\f\u0010B\u001a\u00020\u001c*\u00020CH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u0018\u0010'\u001a\u00020\u000e*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0018\u0010+\u001a\u00020\u001c*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/CacheBuilder;", "", "project", "Lorg/gradle/api/Project;", "binary", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBinary;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBinary;)V", "getBinary", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBinary;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeCompilation;", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeCompilation;", "debuggable", "", "getDebuggable", "()Z", "konanCacheKind", "Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "getKonanCacheKind", "()Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "libraries", "Lorg/gradle/api/file/FileCollection;", "getLibraries", "()Lorg/gradle/api/file/FileCollection;", "optimized", "getOptimized", "optionsAwareCacheName", "", "getOptionsAwareCacheName", "()Ljava/lang/String;", "getProject", "()Lorg/gradle/api/Project;", "rootCacheDirectory", "Ljava/io/File;", "getRootCacheDirectory", "()Ljava/io/File;", "target", "getTarget", "cacheWorks", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getCacheWorks", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Z", "cachedName", "getCachedName", "(Ljava/lang/String;)Ljava/lang/String;", "buildCompilerArgs", "", "computeDependenciesHash", "dependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "ensureCompilerProvidedLibPrecached", "", "platformLibName", "platformLibs", "", "visitedLibs", "", "ensureCompilerProvidedLibsPrecached", "ensureDependencyPrecached", "visitedDependencies", "getAllDependencies", "", "getCacheDirectory", "needCache", "libraryPath", "toHexString", "", "kotlin-gradle-plugin"})
public final class CacheBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final NativeBinary binary;

    private final KotlinNativeCompilation getCompilation() {
        return this.binary.getCompilation();
    }

    private final boolean getOptimized() {
        return this.binary.getOptimized();
    }

    private final boolean getDebuggable() {
        return this.binary.getDebuggable();
    }

    private final NativeCacheKind getKonanCacheKind() {
        return KotlinNativeToolRunnerKt.getKonanCacheKind(this.project);
    }

    private final FileCollection getLibraries() {
        return KotlinNativeTasksKt.access$filterOutPublishableInteropLibs(this.getCompilation().getCompileDependencyFiles(), this.project);
    }

    private final String getTarget() {
        return this.getCompilation().getKonanTarget().getName();
    }

    private final String getOptionsAwareCacheName() {
        return this.getTarget() + (this.getDebuggable() ? "-g" : "") + (Object)((Object)this.getKonanCacheKind());
    }

    private final java.io.File getRootCacheDirectory() {
        return FilesKt.resolve((java.io.File)new java.io.File(KotlinNativeToolRunnerKt.getKonanHome(this.project)), (String)("klib/cache/" + this.getOptionsAwareCacheName()));
    }

    private final Set<ResolvedDependency> getAllDependencies(ResolvedDependency dependency) {
        boolean bl = false;
        Set allDependencies = new LinkedHashSet();
        Function1<ResolvedDependency, Unit> $fun$traverseAllDependencies$1 = new Function1<ResolvedDependency, Unit>(allDependencies){
            final /* synthetic */ Set $allDependencies;

            public final void invoke(@NotNull ResolvedDependency dependency) {
                Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
                if (this.$allDependencies.contains(dependency)) {
                    return;
                }
                this.$allDependencies.add(dependency);
                Set set2 = dependency.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"dependency.children");
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ResolvedDependency it = (ResolvedDependency)element$iv;
                    boolean bl = false;
                    ResolvedDependency resolvedDependency = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"it");
                    this.invoke(resolvedDependency);
                }
            }
            {
                this.$allDependencies = set2;
                super(1);
            }
        };
        Set set2 = dependency.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"dependency.children");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency it = (ResolvedDependency)element$iv;
            boolean bl2 = false;
            ResolvedDependency resolvedDependency = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"it");
            $fun$traverseAllDependencies$1.invoke(resolvedDependency);
        }
        return allDependencies;
    }

    private final String toHexString(@NotNull byte[] $receiver) {
        return ArraysKt.joinToString$default((byte[])$receiver, (CharSequence)"", null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String computeDependenciesHash(ResolvedDependency dependency) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        ResolvedDependency it;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Set set2 = dependency.getModuleArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"dependency.moduleArtifacts");
        Iterable iterable = this.getAllDependencies(dependency);
        Object object = set2;
        boolean $i$f$flatMap = false;
        Object object2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ResolvedDependency)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getModuleArtifacts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object object3 = (List)destination$iv$iv;
        Iterable $this$map$iv = SetsKt.plus((Set)object, (Iterable)((Iterable)object3));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ResolvedArtifact)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            ResolvedDependency resolvedDependency = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"it");
            java.io.File file = resolvedDependency.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
            object3 = file.getAbsolutePath();
            object.add(object3);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        object2 = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                String it = (String)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (String)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        String allArtifactsPaths2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)object2, (Comparator)comparator), (CharSequence)"|", null, null, (int)0, null, (Function1)computeDependenciesHash.allArtifactsPaths.4.INSTANCE, (int)30, null);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        object2 = allArtifactsPaths2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        object = digest;
        boolean bl2 = false;
        Object object4 = object2;
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object4).getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object3 = byArray;
        byte[] hash2 = ((MessageDigest)object).digest((byte[])object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)hash2, (String)"hash");
        return this.toHexString(hash2);
    }

    private final java.io.File getCacheDirectory(ResolvedDependency dependency) {
        java.io.File moduleCacheDirectory = new java.io.File(this.getRootCacheDirectory(), dependency.getModuleName());
        java.io.File versionCacheDirectory = new java.io.File(moduleCacheDirectory, dependency.getModuleVersion());
        return new java.io.File(versionCacheDirectory, this.computeDependenciesHash(dependency));
    }

    private final boolean needCache(String libraryPath) {
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        java.io.File file = gradle.getGradleUserHomeDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.gradle.gradleUserHomeDir");
        String string = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.gradle.gradleUserHomeDir.absolutePath");
        return StringsKt.startsWith$default((String)libraryPath, (String)string, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)libraryPath, (String)".klib", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureDependencyPrecached(ResolvedDependency dependency, Set<ResolvedDependency> visitedDependencies) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object object;
        java.io.File cacheDirectory;
        Object object2;
        Iterable $this$mapTo$iv$iv2;
        void $this$filterTo$iv$iv2;
        Object element$iv2;
        if (visitedDependencies.contains(dependency)) {
            return;
        }
        Collection collection = visitedDependencies;
        boolean bl = false;
        collection.add(dependency);
        Set set2 = dependency.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"dependency.children");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ResolvedDependency it = (ResolvedDependency)element$iv2;
            boolean bl2 = false;
            ResolvedDependency resolvedDependency = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"it");
            this.ensureDependencyPrecached(resolvedDependency, visitedDependencies);
        }
        Set set3 = dependency.getModuleArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"dependency.moduleArtifacts");
        Iterable $this$filter$iv = set3;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ResolvedArtifact it = (ResolvedArtifact)element$iv$iv;
            boolean bl3 = false;
            ResolvedArtifact resolvedArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"it");
            java.io.File file = resolvedArtifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.file.absolutePath");
            if (!this.needCache(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List artifactsToAddToCache = (List)destination$iv$iv;
        if (artifactsToAddToCache.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = this.getAllDependencies(dependency);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            boolean bl4;
            void childDependency;
            block22: {
                ResolvedDependency bl3 = (ResolvedDependency)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl5 = false;
                Set set4 = childDependency.getModuleArtifacts();
                Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"childDependency.moduleArtifacts");
                Iterable $this$any$iv = set4;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv3 : $this$any$iv) {
                        ResolvedArtifact it = (ResolvedArtifact)element$iv3;
                        boolean bl6 = false;
                        ResolvedArtifact resolvedArtifact = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"it");
                        java.io.File file = resolvedArtifact.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
                        String string = file.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.file.absolutePath");
                        if (!StringsKt.endsWith$default((String)string, (String)".klib", (boolean)false, (int)2, null)) continue;
                        bl4 = true;
                        break block22;
                    }
                    bl4 = false;
                }
            }
            boolean hasKlibs = bl4;
            cacheDirectory = this.getCacheDirectory((ResolvedDependency)childDependency);
            if (hasKlibs && !cacheDirectory.exists()) {
                return;
            }
            object = cacheDirectory;
            object2.add(object);
        }
        Iterable $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            java.io.File it = (java.io.File)element$iv$iv;
            boolean bl7 = false;
            if (!it.exists()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List dependenciesCacheDirectories = (List)destination$iv$iv2;
        java.io.File cacheDirectory2 = this.getCacheDirectory(dependency);
        cacheDirectory2.mkdirs();
        Iterable $this$map$iv2 = artifactsToAddToCache;
        boolean $i$f$map2 = false;
        Iterable $i$f$filterTo22 = $this$map$iv2;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            cacheDirectory = (ResolvedArtifact)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl8 = false;
            void v11 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"it");
            java.io.File file = v11.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.file.absolutePath");
            object = KotlinLibraryImplKt.createKotlinLibrary$default((File)new File(string), (boolean)false, (int)2, null);
            object2.add(object);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv3;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it22;
            KotlinLibrary bl8 = (KotlinLibrary)element$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl9 = false;
            object = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)it22));
            object2.put(object, element$iv$iv);
        }
        Map artifactsLibraries = destination$iv$iv4;
        $i$f$associateBy = false;
        List sortedLibraries = new ArrayList();
        capacity$iv = 0;
        Set visitedLibraries = new LinkedHashSet();
        Function1<KotlinLibrary, Unit> $fun$dfs$2 = new Function1<KotlinLibrary, Unit>(visitedLibraries, artifactsLibraries, sortedLibraries){
            final /* synthetic */ Set $visitedLibraries;
            final /* synthetic */ Map $artifactsLibraries;
            final /* synthetic */ List $sortedLibraries;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KotlinLibrary library) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                Collection collection = this.$visitedLibraries;
                boolean bl = false;
                collection.add(library);
                Iterable $this$map$iv = KotlinLibraryKt.getUnresolvedDependencies((BaseKotlinLibrary)((BaseKotlinLibrary)library));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UnresolvedLibrary unresolvedLibrary = (UnresolvedLibrary)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    KotlinLibrary kotlinLibrary = (KotlinLibrary)this.$artifactsLibraries.get(it.getPath());
                    collection2.add(kotlinLibrary);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    KotlinLibrary it = (KotlinLibrary)element$iv;
                    boolean bl3 = false;
                    if (it == null || this.$visitedLibraries.contains(it)) continue;
                    this.invoke(it);
                }
                collection = this.$sortedLibraries;
                bl = false;
                collection.add(library);
            }
            {
                this.$visitedLibraries = set2;
                this.$artifactsLibraries = map2;
                this.$sortedLibraries = list2;
                super(1);
            }
        };
        for (KotlinLibrary library : artifactsLibraries.values()) {
            if (visitedLibraries.contains(library)) continue;
            $fun$dfs$2.invoke(library);
        }
        for (KotlinLibrary library : sortedLibraries) {
            void $this$mapNotNullTo$iv$iv;
            Object object3;
            boolean bl10;
            Iterable $this$mapTo$iv$iv3;
            Iterable list$iv$iv;
            ResolvedDependency it;
            Iterable $this$flatMapTo$iv$iv;
            Object item$iv$iv;
            if (new java.io.File(cacheDirectory2, this.getCachedName(KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)library)))).exists()) continue;
            this.project.getLogger().info("Compiling " + KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)library)) + " to cache");
            Object[] objectArray = new String[4];
            objectArray[0] = "-p";
            String string = this.getKonanCacheKind().getProduce();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = string;
            objectArray[2] = "-target";
            objectArray[3] = this.getTarget();
            List args = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.getDebuggable()) {
                item$iv$iv = args;
                String element$iv$iv = "-g";
                boolean it22 = false;
                item$iv$iv.add(element$iv$iv);
            }
            item$iv$iv = args;
            String element$iv$iv = "-Xadd-cache=" + library.getLibraryFile().getAbsolutePath();
            boolean it22 = false;
            item$iv$iv.add(element$iv$iv);
            item$iv$iv = args;
            element$iv$iv = "-Xcache-directory=" + cacheDirectory2.getAbsolutePath();
            it22 = false;
            item$iv$iv.add(element$iv$iv);
            item$iv$iv = args;
            element$iv$iv = "-Xcache-directory=" + this.getRootCacheDirectory().getAbsolutePath();
            it22 = false;
            item$iv$iv.add(element$iv$iv);
            Iterable $this$forEach$iv2 = dependenciesCacheDirectories;
            boolean $i$f$forEach2 = false;
            for (Object element$iv4 : $this$forEach$iv2) {
                java.io.File it3 = (java.io.File)element$iv4;
                boolean bl11 = false;
                Collection bl6 = args;
                String hasKlibs = "-Xcache-directory=" + it3.getAbsolutePath();
                boolean bl12 = false;
                bl6.add(hasKlibs);
            }
            Iterable $this$flatMap$iv = this.getAllDependencies(dependency);
            boolean $i$f$flatMap = false;
            Iterable it22 = $this$flatMap$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                it = (ResolvedDependency)element$iv$iv2;
                boolean bl13 = false;
                list$iv$iv = it.getModuleArtifacts();
                CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv3 = (List)destination$iv$iv5;
            boolean $i$f$map3 = false;
            $this$flatMapTo$iv$iv = $this$map$iv3;
            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            Iterator bl11 = $this$mapTo$iv$iv3.iterator();
            while (bl11.hasNext()) {
                Object item$iv$iv2 = bl11.next();
                list$iv$iv = (ResolvedArtifact)item$iv$iv2;
                object2 = destination$iv$iv5;
                bl10 = false;
                ResolvedDependency resolvedDependency = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"it");
                object = resolvedDependency.getFile();
                object2.add(object);
            }
            $this$forEach$iv2 = KotlinNativeTasksKt.access$filterKlibsPassedToCompiler((List)destination$iv$iv5, this.project);
            $i$f$forEach2 = false;
            for (Object element$iv4 : $this$forEach$iv2) {
                java.io.File it4 = (java.io.File)element$iv4;
                boolean bl14 = false;
                Collection item$iv$iv2 = args;
                object3 = "-l";
                bl10 = false;
                item$iv$iv2.add(object3);
                item$iv$iv2 = args;
                object3 = it4.getAbsolutePath();
                bl10 = false;
                item$iv$iv2.add(object3);
            }
            Iterable $this$mapNotNull$iv = KotlinLibraryKt.getUnresolvedDependencies((BaseKotlinLibrary)((BaseKotlinLibrary)library));
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv3 = $this$mapNotNull$iv;
            destination$iv$iv5 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach3 = false;
            object3 = $this$forEach$iv$iv$iv.iterator();
            while (object3.hasNext()) {
                KotlinLibrary kotlinLibrary;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = object3.next();
                boolean bl15 = false;
                UnresolvedLibrary it5 = (UnresolvedLibrary)element$iv$iv3;
                boolean bl16 = false;
                if ((KotlinLibrary)artifactsLibraries.get(it5.getPath()) == null) continue;
                boolean bl17 = false;
                boolean bl18 = false;
                KotlinLibrary it$iv$iv = kotlinLibrary;
                boolean bl19 = false;
                destination$iv$iv5.add(it$iv$iv);
            }
            $this$forEach$iv2 = (List)destination$iv$iv5;
            $i$f$forEach2 = false;
            for (Object element$iv4 : $this$forEach$iv2) {
                KotlinLibrary it6 = (KotlinLibrary)element$iv4;
                boolean bl20 = false;
                Collection collection2 = args;
                object3 = "-l";
                boolean bl21 = false;
                collection2.add(object3);
                collection2 = args;
                object3 = it6.getLibraryFile().getAbsolutePath();
                bl21 = false;
                collection2.add(object3);
            }
            new KonanCompilerRunner(this.project, null, false, 6, null).run(args);
        }
    }

    private final String getCachedName(@NotNull String $receiver) {
        Object object;
        block3: {
            boolean bl;
            Object object2;
            block2: {
                object = this.getKonanCacheKind().getOutputKind();
                if (object == null) break block2;
                object2 = object;
                bl = false;
                boolean bl2 = false;
                CompilerOutputKind it = object2;
                boolean bl3 = false;
                object = it.prefix(this.getCompilation().getKonanTarget()) + $receiver + "-cache" + it.suffix(this.getCompilation().getKonanTarget());
                if (object != null) break block3;
            }
            object2 = "No output for kind " + (Object)((Object)this.getKonanCacheKind());
            bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        return object;
    }

    private final void ensureCompilerProvidedLibPrecached(String platformLibName, Map<String, ? extends java.io.File> platformLibs2, Set<String> visitedLibs) {
        boolean bl;
        String string;
        Object object;
        if (visitedLibs.contains(platformLibName)) {
            return;
        }
        Collection collection = visitedLibs;
        boolean bl2 = false;
        collection.add(platformLibName);
        java.io.File file = platformLibs2.get(platformLibName);
        if (file == null) {
            String string2 = platformLibName + " is not found in platform libs";
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        java.io.File platformLib = file;
        if (new java.io.File(this.getRootCacheDirectory(), this.getCachedName(platformLibName)).exists()) {
            return;
        }
        String string3 = platformLib.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"platformLib.absolutePath");
        for (UnresolvedLibrary dependency : KotlinLibraryKt.getUnresolvedDependencies((BaseKotlinLibrary)((BaseKotlinLibrary)KotlinLibraryImplKt.createKotlinLibrary$default((File)new File(string3), (boolean)false, (int)2, null)))) {
            this.ensureCompilerProvidedLibPrecached(dependency.getPath(), platformLibs2, visitedLibs);
        }
        this.project.getLogger().info("Compiling " + platformLibName + " (" + visitedLibs.size() + '/' + platformLibs2.size() + ") to cache");
        Object[] objectArray = new String[4];
        objectArray[0] = "-p";
        String string4 = this.getKonanCacheKind().getProduce();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[1] = string4;
        objectArray[2] = "-target";
        objectArray[3] = this.getTarget();
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.getDebuggable()) {
            object = args;
            string = "-g";
            bl = false;
            object.add(string);
        }
        object = args;
        string = "-Xadd-cache=" + platformLib.getAbsolutePath();
        bl = false;
        object.add(string);
        object = args;
        string = "-Xcache-directory=" + this.getRootCacheDirectory().getAbsolutePath();
        bl = false;
        object.add(string);
        new KonanCompilerRunner(this.project, null, false, 6, null).run(args);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCompilerProvidedLibsPrecached() {
        void $this$associateByTo$iv$iv;
        FileCollection fileCollection = this.getLibraries().filter((Spec)new Spec<java.io.File>(this){
            final /* synthetic */ CacheBuilder this$0;

            public final boolean isSatisfiedBy(java.io.File it) {
                java.io.File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                return KotlinNativeTasksKt.access$providedByCompiler(file, this.this$0.getProject());
            }
            {
                this.this$0 = cacheBuilder;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"libraries.filter { it.pr\u2026idedByCompiler(project) }");
        Iterable $this$associateBy$iv = (Iterable)fileCollection;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            java.io.File file = (java.io.File)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            map2.put(string, element$iv$iv);
        }
        Map platformLibs2 = destination$iv$iv;
        $i$f$associateBy = false;
        Set visitedLibs = new LinkedHashSet();
        Iterator iterator = platformLibs2.keySet().iterator();
        while (iterator.hasNext()) {
            String platformLibName;
            String string = platformLibName = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"platformLibName");
            this.ensureCompilerProvidedLibPrecached(string, platformLibs2, visitedLibs);
        }
    }

    private final boolean getCacheWorks(@NotNull KonanTarget $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)KonanTarget.IOS_X64.INSTANCE) || Intrinsics.areEqual((Object)$receiver, (Object)KonanTarget.MACOS_X64.INSTANCE);
    }

    @NotNull
    public final List<String> buildCompilerArgs() {
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $receiver = list2;
        boolean bl4 = false;
        if (this.getKonanCacheKind() != NativeCacheKind.NONE && !this.getOptimized() && this.getCacheWorks(this.getCompilation().getKonanTarget())) {
            Configuration compileDependencyConfiguration;
            this.getRootCacheDirectory().mkdirs();
            this.ensureCompilerProvidedLibsPrecached();
            $receiver.add("-Xcache-directory=" + this.getRootCacheDirectory().getAbsolutePath());
            boolean bl5 = false;
            Set visitedDependencies = new LinkedHashSet();
            boolean bl6 = false;
            Set allCacheDirectories = new LinkedHashSet();
            Configuration configuration2 = compileDependencyConfiguration = this.project.getConfigurations().getByName(this.getCompilation().getCompileDependencyConfigurationName());
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"compileDependencyConfiguration");
            ResolvedConfiguration resolvedConfiguration2 = configuration2.getResolvedConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration2, (String)"compileDependencyConfigu\u2026ion.resolvedConfiguration");
            Iterator iterator = resolvedConfiguration2.getFirstLevelModuleDependencies().iterator();
            while (iterator.hasNext()) {
                ResolvedDependency root;
                ResolvedDependency resolvedDependency = root = (ResolvedDependency)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"root");
                this.ensureDependencyPrecached(resolvedDependency, visitedDependencies);
                Iterator iterator2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)root), (Iterable)this.getAllDependencies(root)).iterator();
                while (iterator2.hasNext()) {
                    ResolvedDependency dependency;
                    ResolvedDependency resolvedDependency2 = dependency = (ResolvedDependency)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency2, (String)"dependency");
                    java.io.File cacheDirectory = this.getCacheDirectory(resolvedDependency2);
                    if (!cacheDirectory.exists()) continue;
                    Collection collection = allCacheDirectories;
                    String string = cacheDirectory.getAbsolutePath();
                    boolean bl7 = false;
                    collection.add(string);
                }
            }
            for (String cacheDirectory : allCacheDirectories) {
                $receiver.add("-Xcache-directory=" + cacheDirectory);
            }
        }
        return list2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NativeBinary getBinary() {
        return this.binary;
    }

    public CacheBuilder(@NotNull Project project, @NotNull NativeBinary binary) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
        this.project = project;
        this.binary = binary;
    }
}

