/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.read.dao.ColumnNameMap;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.BinaryRowProtocol;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.TextRowProtocol;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.input.StandardPacketInputStream;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class SelectResultSet
implements ResultSet {
    private static final String NOT_UPDATABLE_ERROR = "Updates are not supported when using ResultSet.CONCUR_READ_ONLY";
    private static final DateTimeFormatter TEXT_LOCAL_DATE_TIME;
    private static final DateTimeFormatter TEXT_OFFSET_DATE_TIME;
    private static final DateTimeFormatter TEXT_ZONED_DATE_TIME;
    private static final int BIT_LAST_FIELD_NOT_NULL = 0;
    private static final int BIT_LAST_FIELD_NULL = 1;
    private static final int BIT_LAST_ZERO_DATE = 2;
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    private static final ColumnInformation[] INSERT_ID_COLUMNS;
    private static final Pattern isIntegerRegex;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected boolean isBinaryEncoded;
    protected TimeZone timeZone;
    protected Options options;
    private Protocol protocol;
    private PacketInputStream reader;
    protected ColumnInformation[] columnsInformation;
    private boolean isEof;
    protected int columnInformationLength;
    protected boolean noBackslashEscapes;
    private boolean callableResult;
    private MariaDbStatement statement;
    private RowProtocol row;
    private int dataFetchTime;
    private boolean streaming;
    private byte[][] data;
    private int dataSize;
    private int fetchSize;
    private int resultSetScrollType;
    private int rowPointer;
    private ColumnNameMap columnNameMap;
    private int lastValueNull;
    private int lastRowPointer = -1;
    private int dataTypeMappingFlags;
    private boolean returnTableAlias;
    private boolean isClosed;
    private boolean eofDeprecated;
    private ReentrantLock lock;

    public SelectResultSet(ColumnInformation[] columnInformation, Results results, Protocol protocol, PacketInputStream reader, boolean callableResult, boolean eofDeprecated) throws IOException, SQLException {
        this.statement = results.getStatement();
        this.isClosed = false;
        this.protocol = protocol;
        this.options = protocol.getOptions();
        this.noBackslashEscapes = protocol.noBackslashEscapes();
        this.timeZone = protocol.getTimeZone();
        this.dataTypeMappingFlags = protocol.getDataTypeMappingFlags();
        this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        this.columnsInformation = columnInformation;
        this.columnNameMap = new ColumnNameMap(this.columnsInformation);
        this.columnInformationLength = columnInformation.length;
        this.reader = reader;
        this.isEof = false;
        this.isBinaryEncoded = results.isBinaryFormat();
        this.row = this.isBinaryEncoded ? new BinaryRowProtocol(this.columnsInformation, this.columnInformationLength, results.getMaxFieldSize()) : new TextRowProtocol(results.getMaxFieldSize());
        this.fetchSize = results.getFetchSize();
        this.resultSetScrollType = results.getResultSetScrollType();
        this.dataSize = 0;
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = callableResult;
        this.eofDeprecated = eofDeprecated;
        if (this.fetchSize == 0 || callableResult) {
            this.data = new byte[10][];
            this.fetchAllResults();
            this.streaming = false;
        } else {
            this.lock = protocol.getLock();
            protocol.setActiveStreamingResult(results);
            protocol.removeHasMoreResults();
            this.data = new byte[Math.max(10, this.fetchSize)][];
            this.nextStreamingValue();
            this.streaming = true;
        }
    }

    public SelectResultSet(ColumnInformation[] columnInformation, List<byte[]> resultSet, Protocol protocol, int resultSetScrollType) {
        this.statement = null;
        this.isClosed = false;
        this.row = new TextRowProtocol(0);
        if (protocol != null) {
            this.options = protocol.getOptions();
            this.timeZone = protocol.getTimeZone();
            this.dataTypeMappingFlags = protocol.getDataTypeMappingFlags();
            this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        } else {
            this.options = null;
            this.timeZone = TimeZone.getDefault();
            this.dataTypeMappingFlags = 3;
            this.returnTableAlias = false;
        }
        this.protocol = null;
        this.columnsInformation = columnInformation;
        this.columnNameMap = new ColumnNameMap(this.columnsInformation);
        this.columnInformationLength = columnInformation.length;
        this.isEof = true;
        this.isBinaryEncoded = false;
        this.fetchSize = 0;
        this.resultSetScrollType = resultSetScrollType;
        this.data = (byte[][])resultSet.toArray((T[])new byte[10][]);
        this.dataSize = resultSet.size();
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = false;
        this.streaming = false;
    }

    public static ResultSet createGeneratedData(long[] data, Protocol protocol, boolean findColumnReturnsOne) {
        ColumnInformation[] columns = new ColumnInformation[]{ColumnInformation.create("insert_id", ColumnType.BIGINT)};
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (long rowData : data) {
            if (rowData == 0L) continue;
            rows.add(StandardPacketInputStream.create(String.valueOf(rowData).getBytes()));
        }
        if (findColumnReturnsOne) {
            return new SelectResultSet(columns, rows, protocol, 1005){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new SelectResultSet(columns, rows, protocol, 1005);
    }

    public static ResultSet createResultSet(String[] columnNames, ColumnType[] columnTypes, String[][] data, Protocol protocol) {
        int columnNameLength = columnNames.length;
        ColumnInformation[] columns = new ColumnInformation[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnInformation.create(columnNames[i], columnTypes[i]);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (String[] rowData : data) {
            assert (rowData.length == columnNameLength);
            byte[][] rowBytes = new byte[rowData.length][];
            for (int i = 0; i < rowData.length; ++i) {
                if (rowData[i] == null) continue;
                rowBytes[i] = rowData[i].getBytes();
            }
            rows.add(StandardPacketInputStream.create(rowBytes, columnTypes));
        }
        return new SelectResultSet(columns, rows, protocol, 1005);
    }

    public static SelectResultSet createEmptyResultSet() {
        return new SelectResultSet(INSERT_ID_COLUMNS, new ArrayList<byte[]>(), null, 1005);
    }

    private void fetchAllResults() throws IOException, SQLException {
        this.dataSize = 0;
        while (this.readNextValue()) {
        }
        ++this.dataFetchTime;
    }

    public void fetchRemaining() throws SQLException {
        if (!this.isEof) {
            this.lock.lock();
            try {
                this.lastRowPointer = -1;
                while (!this.isEof) {
                    this.addStreamingValue();
                }
            }
            catch (SQLException queryException) {
                throw ExceptionMapper.getException(queryException, null, this.statement, false);
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            ++this.dataFetchTime;
        }
    }

    private SQLException handleIoException(IOException ioe) {
        return ExceptionMapper.getException(new SQLException("Server has closed the connection. If result set contain huge amount of data, Server expects client to read off the result set relatively fast. In this case, please consider increasing net_wait_timeout session variable / processing your result set faster (check Streaming result sets documentation for more information)", SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioe), null, this.statement, false);
    }

    private void nextStreamingValue() throws IOException, SQLException {
        this.lastRowPointer = -1;
        if (this.resultSetScrollType == 1003) {
            this.dataSize = 0;
        }
        this.addStreamingValue();
    }

    private void addStreamingValue() throws IOException, SQLException {
        for (int fetchSizeTmp = this.fetchSize; fetchSizeTmp > 0 && this.readNextValue(); --fetchSizeTmp) {
        }
        ++this.dataFetchTime;
    }

    private boolean readNextValue() throws IOException, SQLException {
        byte[] buf = this.reader.getPacketArray(false);
        if (buf[0] == -1) {
            this.protocol.removeActiveStreamingResult();
            this.protocol.removeHasMoreResults();
            this.protocol.setHasWarnings(false);
            ErrorPacket errorPacket = new ErrorPacket(new Buffer(buf));
            this.resetVariables();
            if (this.statement != null) {
                throw ExceptionMapper.getException(new SQLException("(conn=" + this.statement.getServerThreadId() + ") " + errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorNumber()), null, this.statement, false);
            }
            throw ExceptionMapper.getException(new SQLException(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorNumber()), null, this.statement, false);
        }
        if (buf[0] == -2 && (this.eofDeprecated && buf.length < 0xFFFFFF || !this.eofDeprecated && buf.length < 8)) {
            int serverStatus;
            int warnings;
            if (!this.eofDeprecated) {
                warnings = (buf[1] & 0xFF) + ((buf[2] & 0xFF) << 8);
                serverStatus = (buf[3] & 0xFF) + ((buf[4] & 0xFF) << 8);
                if (this.callableResult) {
                    serverStatus |= 8;
                }
            } else {
                int pos = this.skipLengthEncodedValue(buf, 1);
                pos = this.skipLengthEncodedValue(buf, pos);
                serverStatus = (buf[pos++] & 0xFF) + ((buf[pos++] & 0xFF) << 8);
                warnings = (buf[pos++] & 0xFF) + ((buf[pos] & 0xFF) << 8);
                this.callableResult = (serverStatus & 0x1000) != 0;
            }
            this.protocol.setServerStatus((short)serverStatus);
            this.protocol.setHasWarnings(warnings > 0);
            if ((serverStatus & 8) == 0) {
                this.protocol.removeActiveStreamingResult();
            }
            this.resetVariables();
            return false;
        }
        if (this.dataSize + 1 >= this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize++] = buf;
        return true;
    }

    protected byte[] getCurrentRowData() {
        return this.data[this.rowPointer];
    }

    protected void updateRowData(byte[] rawData) {
        this.data[this.rowPointer] = rawData;
        this.row.resetRow(this.data[this.rowPointer]);
    }

    protected void deleteCurrentRowData() throws SQLException {
        System.arraycopy(this.data, this.rowPointer + 1, this.data, this.rowPointer, this.dataSize - 1 - this.rowPointer);
        this.data[this.dataSize - 1] = null;
        --this.dataSize;
        this.lastRowPointer = -1;
        this.previous();
    }

    protected void addRowData(byte[] rawData) {
        if (this.dataSize + 1 >= this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize] = rawData;
        this.rowPointer = this.dataSize++;
    }

    private int skipLengthEncodedValue(byte[] buf, int pos) {
        int type = buf[pos++] & 0xFF;
        switch (type) {
            case 251: {
                return pos;
            }
            case 252: {
                return pos + 2 + (0xFFFF & (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8));
            }
            case 253: {
                return pos + 3 + (0xFFFFFF & (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8) + ((buf[pos + 2] & 0xFF) << 16));
            }
            case 254: {
                return (int)((long)(pos + 8) + ((long)(buf[pos] & 0xFF) + ((long)(buf[pos + 1] & 0xFF) << 8) + ((long)(buf[pos + 2] & 0xFF) << 16) + ((long)(buf[pos + 3] & 0xFF) << 24) + ((long)(buf[pos + 4] & 0xFF) << 32) + ((long)(buf[pos + 5] & 0xFF) << 40) + ((long)(buf[pos + 6] & 0xFF) << 48) + ((long)(buf[pos + 7] & 0xFF) << 56)));
            }
        }
        return pos + type;
    }

    private void growDataArray() {
        int newCapacity = this.data.length + (this.data.length >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        this.data = (byte[][])Arrays.copyOf(this.data, newCapacity);
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (!this.isEof) {
            this.lock.lock();
            try {
                while (!this.isEof) {
                    this.dataSize = 0;
                    this.readNextValue();
                }
            }
            catch (SQLException queryException) {
                throw ExceptionMapper.getException(queryException, null, this.statement, false);
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.resetVariables();
                this.lock.unlock();
            }
        }
        this.resetVariables();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        if (this.statement != null) {
            this.statement.checkCloseOnCompletion(this);
            this.statement = null;
        }
    }

    private void resetVariables() {
        this.protocol = null;
        this.reader = null;
        this.isEof = true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not permit on a closed resultSet", "HY000");
        }
        if (this.rowPointer < this.dataSize - 1) {
            ++this.rowPointer;
            return true;
        }
        if (this.streaming && !this.isEof) {
            this.lock.lock();
            try {
                if (!this.isEof) {
                    this.nextStreamingValue();
                }
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            if (this.resultSetScrollType == 1003) {
                this.rowPointer = 0;
                return this.dataSize > 0;
            }
            ++this.rowPointer;
            return this.dataSize > this.rowPointer;
        }
        this.rowPointer = this.dataSize;
        return false;
    }

    private void checkObjectRange(int position) throws SQLException {
        if (this.rowPointer < 0) {
            throw new SQLDataException("Current position is before the first row", "22023");
        }
        if (this.rowPointer >= this.dataSize) {
            throw new SQLDataException("Current position is after the last row", "22023");
        }
        if (position <= 0 || position > this.columnInformationLength) {
            throw new SQLDataException("No such column: " + position, "22023");
        }
        if (this.lastRowPointer != this.rowPointer) {
            this.row.resetRow(this.data[this.rowPointer]);
            this.lastRowPointer = this.rowPointer;
        }
        this.lastValueNull = this.row.setPosition(position - 1) ? 1 : 0;
    }

    private boolean lastValueWasNull() {
        return (this.lastValueNull & 1) != 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime > 0 ? this.rowPointer == -1 && this.dataSize > 0 : this.rowPointer == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize) {
            return false;
        }
        if (this.streaming && !this.isEof) {
            this.lock.lock();
            try {
                if (!this.isEof) {
                    this.addStreamingValue();
                }
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            return this.dataSize == this.rowPointer;
        }
        return this.dataSize > 0 || this.dataFetchTime > 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime == 1 && this.rowPointer == 0 && this.dataSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize - 1) {
            return false;
        }
        if (this.isEof) {
            return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
        }
        this.lock.lock();
        try {
            if (!this.isEof) {
                this.addStreamingValue();
            }
        }
        catch (IOException ioe) {
            throw this.handleIoException(ioe);
        }
        finally {
            this.lock.unlock();
        }
        if (this.isEof) {
            return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        this.fetchRemaining();
        this.rowPointer = this.dataSize;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = 0;
        return this.dataSize > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        this.fetchRemaining();
        this.rowPointer = this.dataSize - 1;
        return this.dataSize > 0;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.streaming) {
            return 0;
        }
        return this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (row >= 0 && row <= this.dataSize) {
            this.rowPointer = row - 1;
            return true;
        }
        this.fetchRemaining();
        if (row >= 0) {
            if (row <= this.dataSize) {
                this.rowPointer = row - 1;
                return true;
            }
            this.rowPointer = this.dataSize;
            return false;
        }
        if (this.dataSize + row >= 0) {
            this.rowPointer = this.dataSize + row;
            return true;
        }
        this.rowPointer = -1;
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        int newPos = this.rowPointer + rows;
        if (newPos > -1 && newPos <= this.dataSize) {
            this.rowPointer = newPos;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (this.rowPointer > -1) {
            --this.rowPointer;
            return this.rowPointer != -1;
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1001) {
            throw new SQLException("Invalid operation. Allowed direction are ResultSet.FETCH_FORWARD and ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (this.streaming && fetchSize == 0) {
            this.lock.lock();
            try {
                while (!this.isEof) {
                    this.addStreamingValue();
                }
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            this.streaming = this.dataFetchTime == 1;
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetScrollType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    private void checkClose() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not permit on a closed resultSet", "HY000");
        }
    }

    public boolean isCallableResult() {
        return this.callableResult;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public MariaDbStatement getStatement() {
        return this.statement;
    }

    public void setStatement(MariaDbStatement statement) {
        this.statement = statement;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return (this.lastValueNull & 1) != 0 || (this.lastValueNull & 2) != 0;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize(), StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalString(this.columnsInformation[columnIndex - 1], null);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    private String getInternalString(ColumnInformation columnInfo) throws SQLException {
        return this.getInternalString(columnInfo, null);
    }

    private String getInternalString(ColumnInformation columnInfo, Calendar cal) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case STRING: {
                if (this.row.getMaxFieldSize() > 0) {
                    return new String(this.row.buf, this.row.pos, Math.max(this.row.getMaxFieldSize() * 3, this.row.length), StandardCharsets.UTF_8).substring(0, this.row.getMaxFieldSize());
                }
                return new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            }
            case BIT: {
                if (!this.options.tinyInt1isBit || columnInfo.getLength() != 1L) break;
                return this.row.buf[this.row.pos] == 0 ? "0" : "1";
            }
            case TINYINT: {
                if (!this.isBinaryEncoded) break;
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalTinyInt(columnInfo)), columnInfo);
            }
            case SMALLINT: {
                if (!this.isBinaryEncoded) break;
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalSmallInt(columnInfo)), columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                if (!this.isBinaryEncoded) break;
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalMediumInt(columnInfo)), columnInfo);
            }
            case BIGINT: {
                if (!this.isBinaryEncoded) break;
                if (!columnInfo.isSigned()) {
                    return this.zeroFillingIfNeeded(String.valueOf(this.getInternalBigInteger(columnInfo)), columnInfo);
                }
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalLong(columnInfo)), columnInfo);
            }
            case DOUBLE: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalDouble(columnInfo)), columnInfo);
            }
            case FLOAT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalFloat(columnInfo)), columnInfo);
            }
            case TIME: {
                return this.getTimeString(columnInfo);
            }
            case DATE: {
                if (!this.isBinaryEncoded) break;
                Date date = this.getInternalDate(columnInfo, cal);
                if (date == null) {
                    if (!this.isBinaryEncoded) {
                        this.lastValueNull ^= 2;
                        return new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                    }
                    return null;
                }
                return date.toString();
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    Date date = this.getInternalDate(columnInfo, cal);
                    return date == null ? null : date.toString();
                }
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getInternalSmallInt(columnInfo));
            }
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal);
                if (timestamp == null) {
                    if (!this.isBinaryEncoded) {
                        this.lastValueNull ^= 2;
                        return new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                    }
                    return null;
                }
                return timestamp.toString();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                return bigDecimal == null ? null : this.zeroFillingIfNeeded(bigDecimal.toString(), columnInfo);
            }
            case GEOMETRY: {
                return new String(this.row.buf, this.row.pos, this.row.length);
            }
            case NULL: {
                return null;
            }
            default: {
                if (this.row.getMaxFieldSize() > 0) {
                    return new String(this.row.buf, this.row.pos, Math.max(this.row.getMaxFieldSize() * 3, this.row.length), StandardCharsets.UTF_8).substring(0, this.row.getMaxFieldSize());
                }
                return new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            }
        }
        return new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
    }

    private String zeroFillingIfNeeded(String value, ColumnInformation columnInformation) {
        if (columnInformation.isZeroFill()) {
            StringBuilder zeroAppendStr = new StringBuilder();
            long zeroToAdd = columnInformation.getDisplaySize() - value.length();
            while (zeroToAdd-- > 0L) {
                zeroAppendStr.append("0");
            }
            return zeroAppendStr.append(value).toString();
        }
        return value;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalInt(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    private int getInternalInt(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            return this.parseInt(columnInfo);
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos];
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = (this.row.buf[this.row.pos] & 0xFF) + ((this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 24);
                if (columnInfo.isSigned()) {
                    return (int)value;
                }
                if (value >= 0L) break;
                value &= 0xFFFFFFFFL;
                break;
            }
            case BIGINT: {
                value = this.getInternalLong(columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getInternalFloat(columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getInternalDouble(columnInfo);
                break;
            }
            default: {
                return this.parseInt(columnInfo);
            }
        }
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, value, columnInfo);
        return (int)value;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalLong(this.columnsInformation[columnIndex - 1]);
    }

    private long getInternalLong(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0L;
        }
        if (!this.isBinaryEncoded) {
            return this.parseLong(columnInfo);
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos];
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.row.buf[this.row.pos] & 0xFF) + ((long)(this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((long)(this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((long)(this.row.buf[this.row.pos + 3] & 0xFF) << 24) + ((long)(this.row.buf[this.row.pos + 4] & 0xFF) << 32) + ((long)(this.row.buf[this.row.pos + 5] & 0xFF) << 40) + ((long)(this.row.buf[this.row.pos + 6] & 0xFF) << 48) + ((long)(this.row.buf[this.row.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2});
                if (unsignedValue.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + unsignedValue + " is not in Long range", "22003", 1264);
                }
                return unsignedValue.longValue();
            }
            case FLOAT: {
                Float floatValue = Float.valueOf(this.getInternalFloat(columnInfo));
                if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + floatValue + " is not in Long range", "22003", 1264);
                }
                return floatValue.longValue();
            }
            case DOUBLE: {
                Double doubleValue = this.getInternalDouble(columnInfo);
                if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + doubleValue + " is not in Long range", "22003", 1264);
                }
                return doubleValue.longValue();
            }
            default: {
                return this.parseLong(columnInfo);
            }
        }
        this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, value, columnInfo);
        return value;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalFloat(this.columnsInformation[columnIndex - 1]);
    }

    private float getInternalFloat(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        if (!this.isBinaryEncoded) {
            switch (columnInfo.getColumnType()) {
                case BIT: {
                    return this.row.buf[this.row.pos];
                }
                case STRING: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: 
                case DOUBLE: 
                case FLOAT: 
                case YEAR: 
                case DECIMAL: 
                case OLDDECIMAL: 
                case VARSTRING: 
                case VARCHAR: {
                    try {
                        return Float.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8)).floatValue();
                    }
                    catch (NumberFormatException nfe) {
                        SQLException sqlException = new SQLException("Incorrect format \"" + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + "\" for getFloat for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                        sqlException.initCause(nfe);
                        throw sqlException;
                    }
                }
            }
            throw new SQLException("getFloat not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos];
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.row.buf[this.row.pos] & 0xFF) + ((long)(this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((long)(this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((long)(this.row.buf[this.row.pos + 3] & 0xFF) << 24) + ((long)(this.row.buf[this.row.pos + 4] & 0xFF) << 32) + ((long)(this.row.buf[this.row.pos + 5] & 0xFF) << 40) + ((long)(this.row.buf[this.row.pos + 6] & 0xFF) << 48) + ((long)(this.row.buf[this.row.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2});
                return unsignedValue.floatValue();
            }
            case FLOAT: {
                int valueFloat = (this.row.buf[this.row.pos] & 0xFF) + ((this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 24);
                return Float.intBitsToFloat(valueFloat);
            }
            case DOUBLE: {
                return (float)this.getInternalDouble(columnInfo);
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                try {
                    return Float.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8)).floatValue();
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format for getFloat for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
            default: {
                throw new SQLException("getFloat not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
            }
        }
        try {
            return Float.valueOf(String.valueOf(value)).floatValue();
        }
        catch (NumberFormatException nfe) {
            SQLException sqlException = new SQLException("Incorrect format for getFloat for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
            sqlException.initCause(nfe);
            throw sqlException;
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalDouble(this.columnsInformation[columnIndex - 1]);
    }

    private double getInternalDouble(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        if (!this.isBinaryEncoded) {
            switch (columnInfo.getColumnType()) {
                case BIT: {
                    return this.row.buf[this.row.pos];
                }
                case STRING: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: 
                case DOUBLE: 
                case FLOAT: 
                case YEAR: 
                case DECIMAL: 
                case OLDDECIMAL: 
                case VARSTRING: 
                case VARCHAR: {
                    try {
                        return Double.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    }
                    catch (NumberFormatException nfe) {
                        SQLException sqlException = new SQLException("Incorrect format \"" + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + "\" for getDouble for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                        sqlException.initCause(nfe);
                        throw sqlException;
                    }
                }
            }
            throw new SQLException("getDouble not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos];
            }
            case TINYINT: {
                return this.getInternalTinyInt(columnInfo);
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt(columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt(columnInfo);
            }
            case BIGINT: {
                long valueLong = (long)(this.row.buf[this.row.pos] & 0xFF) + ((long)(this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((long)(this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((long)(this.row.buf[this.row.pos + 3] & 0xFF) << 24) + ((long)(this.row.buf[this.row.pos + 4] & 0xFF) << 32) + ((long)(this.row.buf[this.row.pos + 5] & 0xFF) << 40) + ((long)(this.row.buf[this.row.pos + 6] & 0xFF) << 48) + ((long)(this.row.buf[this.row.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return valueLong;
                }
                return new BigInteger(1, new byte[]{(byte)(valueLong >> 56), (byte)(valueLong >> 48), (byte)(valueLong >> 40), (byte)(valueLong >> 32), (byte)(valueLong >> 24), (byte)(valueLong >> 16), (byte)(valueLong >> 8), (byte)valueLong}).doubleValue();
            }
            case FLOAT: {
                return this.getInternalFloat(columnInfo);
            }
            case DOUBLE: {
                long valueDouble = (long)(this.row.buf[this.row.pos] & 0xFF) + ((long)(this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((long)(this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((long)(this.row.buf[this.row.pos + 3] & 0xFF) << 24) + ((long)(this.row.buf[this.row.pos + 4] & 0xFF) << 32) + ((long)(this.row.buf[this.row.pos + 5] & 0xFF) << 40) + ((long)(this.row.buf[this.row.pos + 6] & 0xFF) << 48) + ((long)(this.row.buf[this.row.pos + 7] & 0xFF) << 56);
                return Double.longBitsToDouble(valueDouble);
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                try {
                    return Double.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format for getDouble for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
        }
        throw new SQLException("getDouble not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalBigDecimal(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalBigDecimal(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    private BigDecimal getInternalBigDecimal(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigDecimal(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigDecimal.valueOf(this.row.buf[this.row.pos]);
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getInternalTinyInt(columnInfo));
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getInternalSmallInt(columnInfo));
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getInternalMediumInt(columnInfo));
            }
            case BIGINT: {
                long value = (long)(this.row.buf[this.row.pos] & 0xFF) + ((long)(this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((long)(this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((long)(this.row.buf[this.row.pos + 3] & 0xFF) << 24) + ((long)(this.row.buf[this.row.pos + 4] & 0xFF) << 32) + ((long)(this.row.buf[this.row.pos + 5] & 0xFF) << 40) + ((long)(this.row.buf[this.row.pos + 6] & 0xFF) << 48) + ((long)(this.row.buf[this.row.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(value))).setScale(columnInfo.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value}))).setScale(columnInfo.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf(this.getInternalFloat(columnInfo));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.getInternalDouble(columnInfo));
            }
        }
        return new BigDecimal(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        byte[] data = new byte[this.row.getLengthMaxFieldSize()];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
        return data;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalDate(this.columnsInformation[columnIndex - 1], null);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalDate(this.columnsInformation[columnIndex - 1], cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    private Date getInternalDate(ColumnInformation columnInfo, Calendar cal) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            switch (columnInfo.getColumnType()) {
                case TIMESTAMP: 
                case DATETIME: {
                    Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal);
                    if (timestamp == null) {
                        return null;
                    }
                    return new Date(timestamp.getTime());
                }
                case TIME: {
                    throw new SQLException("Cannot read DATE using a Types.TIME field");
                }
                case DATE: {
                    if ("0000-00-00".equals(rawValue)) {
                        this.lastValueNull |= 2;
                        return null;
                    }
                    return new Date(Integer.parseInt(rawValue.substring(0, 4)) - 1900, Integer.parseInt(rawValue.substring(5, 7)) - 1, Integer.parseInt(rawValue.substring(8, 10)));
                }
                case YEAR: {
                    int year = Integer.parseInt(rawValue);
                    if (this.row.length == 2 && columnInfo.getLength() == 2L) {
                        year = year <= 69 ? (year += 2000) : (year += 1900);
                    }
                    return new Date(year - 1900, 0, 1);
                }
            }
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.setTimeZone(this.timeZone);
                java.util.Date utilDate = sdf.parse(rawValue);
                return new Date(utilDate.getTime());
            }
            catch (ParseException e) {
                throw ExceptionMapper.getSqlException("Could not get object as Date : " + e.getMessage(), "S1009", e);
            }
        }
        return this.binaryDate(columnInfo, cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalTime(this.columnsInformation[columnIndex - 1], null);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalTime(this.columnsInformation[columnIndex - 1], cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    private Time getInternalTime(ColumnInformation columnInfo, Calendar cal) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String[] rawPart;
            if (columnInfo.getColumnType() == ColumnType.TIMESTAMP || columnInfo.getColumnType() == ColumnType.DATETIME) {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal);
                return timestamp == null ? null : new Time(timestamp.getTime());
            }
            if (columnInfo.getColumnType() == ColumnType.DATE) {
                throw new SQLException("Cannot read Time using a Types.DATE field");
            }
            String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            if (!this.options.useLegacyDatetimeCode && (raw.startsWith("-") || raw.split(":").length != 3 || raw.indexOf(":") > 3)) {
                throw new SQLException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss");
            }
            boolean negate = raw.startsWith("-");
            if (negate) {
                raw = raw.substring(1);
            }
            if ((rawPart = raw.split(":")).length == 3) {
                int hour = Integer.parseInt(rawPart[0]);
                int minutes = Integer.parseInt(rawPart[1]);
                int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
                Calendar calendar = Calendar.getInstance();
                if (this.options.useLegacyDatetimeCode) {
                    calendar.setLenient(true);
                }
                calendar.clear();
                calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
                int nanoseconds = this.extractNanos(raw);
                calendar.set(14, nanoseconds / 1000000);
                return new Time(calendar.getTimeInMillis());
            }
            throw new SQLException(raw + " cannot be parse as time. time must have \"99:99:99\" format");
        }
        return this.binaryTime(columnInfo, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalTimestamp(this.columnsInformation[columnIndex - 1], cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalTimestamp(this.columnsInformation[columnIndex - 1], null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getInternalTimestamp(ColumnInformation columnInfo, Calendar userCalendar) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            if (rawValue.startsWith("0000-00-00 00:00:00")) {
                this.lastValueNull |= 2;
                return null;
            }
            switch (columnInfo.getColumnType()) {
                case TIME: {
                    Timestamp tt = new Timestamp(this.getInternalTime(columnInfo, userCalendar).getTime());
                    tt.setNanos(this.extractNanos(rawValue));
                    return tt;
                }
            }
            try {
                Timestamp timestamp;
                int hour = 0;
                int minutes = 0;
                int seconds = 0;
                int year = Integer.parseInt(rawValue.substring(0, 4));
                int month = Integer.parseInt(rawValue.substring(5, 7));
                int day = Integer.parseInt(rawValue.substring(8, 10));
                if (rawValue.length() >= 19) {
                    hour = Integer.parseInt(rawValue.substring(11, 13));
                    minutes = Integer.parseInt(rawValue.substring(14, 16));
                    seconds = Integer.parseInt(rawValue.substring(17, 19));
                }
                int nanoseconds = this.extractNanos(rawValue);
                Calendar calendar = userCalendar != null ? userCalendar : (columnInfo.getColumnType().getSqlType() == 93 ? Calendar.getInstance(this.timeZone) : Calendar.getInstance());
                Calendar calendar2 = calendar;
                synchronized (calendar2) {
                    calendar.clear();
                    calendar.set(1, year);
                    calendar.set(2, month - 1);
                    calendar.set(5, day);
                    calendar.set(11, hour);
                    calendar.set(12, minutes);
                    calendar.set(13, seconds);
                    calendar.set(14, nanoseconds / 1000000);
                    timestamp = new Timestamp(calendar.getTime().getTime());
                }
                timestamp.setNanos(nanoseconds);
                return timestamp;
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException n) {
                throw new SQLException("Value \"" + rawValue + "\" cannot be parse as Timestamp");
            }
        }
        return this.binaryTimestamp(columnInfo, userCalendar);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize(), StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public String getCursorName() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MariaDbResultSetMetaData(this.columnsInformation, this.dataTypeMappingFlags, this.returnTableAlias);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.getInternalObject(this.columnsInformation[columnIndex - 1], this.dataTypeMappingFlags);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Method ResultSet.getObject(int columnIndex, Map<String, Class<?>> map) not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Method ResultSet.getObject(String columnLabel, Map<String, Class<?>> map) not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Class type cannot be null");
        }
        this.checkObjectRange(columnIndex);
        ColumnInformation col = this.columnsInformation[columnIndex - 1];
        if (type.equals(String.class)) {
            return (T)this.getInternalString(col, null);
        }
        if (type.equals(Integer.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)Integer.valueOf(this.getInternalInt(col));
        }
        if (type.equals(Long.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)Long.valueOf(this.getInternalLong(col));
        }
        if (type.equals(Short.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)Short.valueOf(this.getInternalShort(col));
        }
        if (type.equals(Double.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)Double.valueOf(this.getInternalDouble(col));
        }
        if (type.equals(Float.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)Float.valueOf(this.getInternalFloat(col));
        }
        if (type.equals(Byte.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)Byte.valueOf(this.getInternalByte(col));
        }
        if (type.equals(byte[].class)) {
            byte[] data = new byte[this.row.getLengthMaxFieldSize()];
            System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
            return (T)data;
        }
        if (type.equals(Date.class)) {
            return (T)this.getInternalDate(col, null);
        }
        if (type.equals(Time.class)) {
            return (T)this.getInternalTime(col, null);
        }
        if (type.equals(Timestamp.class) || type.equals(java.util.Date.class)) {
            return (T)this.getInternalTimestamp(col, null);
        }
        if (type.equals(Boolean.class)) {
            return (T)Boolean.valueOf(this.getInternalBoolean(col));
        }
        if (type.equals(Calendar.class)) {
            Calendar calendar = Calendar.getInstance(this.timeZone);
            Timestamp timestamp = this.getInternalTimestamp(col, null);
            if (timestamp == null) {
                return null;
            }
            calendar.setTimeInMillis(timestamp.getTime());
            return type.cast(calendar);
        }
        if (type.equals(Clob.class) || type.equals(NClob.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            byte[] data = new byte[this.row.getLengthMaxFieldSize()];
            System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
            return (T)new MariaDbClob(data);
        }
        if (type.equals(InputStream.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return (T)new ByteArrayInputStream(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(Reader.class)) {
            String value = this.getInternalString(col);
            if (value == null) {
                return null;
            }
            return (T)new StringReader(value);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getInternalBigDecimal(col);
        }
        if (type.equals(BigInteger.class)) {
            return (T)this.getInternalBigInteger(col);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getInternalBigDecimal(col);
        }
        if (type.equals(LocalDateTime.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            ZonedDateTime zonedDateTime = this.getZonedDateTime(col, LocalDateTime.class);
            return zonedDateTime == null ? null : (T)type.cast(zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
        }
        if (type.equals(ZonedDateTime.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return type.cast(this.getZonedDateTime(col, ZonedDateTime.class));
        }
        if (type.equals(OffsetDateTime.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            ZonedDateTime tmpZonedDateTime = this.getZonedDateTime(col, OffsetDateTime.class);
            return tmpZonedDateTime == null ? null : (T)type.cast(tmpZonedDateTime.toOffsetDateTime());
        }
        if (type.equals(OffsetDateTime.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return type.cast(this.getLocalDate(col));
        }
        if (type.equals(LocalDate.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return type.cast(this.getLocalDate(col));
        }
        if (type.equals(LocalTime.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return type.cast(this.getLocalTime(col));
        }
        if (type.equals(OffsetTime.class)) {
            if (this.lastValueWasNull()) {
                return null;
            }
            return type.cast(this.getOffsetTime(col));
        }
        throw ExceptionMapper.getFeatureNotSupportedException("Type class '" + type.getName() + "' is not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return type.cast(this.getObject(this.findColumn(columnLabel), type));
    }

    private Object getInternalObject(ColumnInformation columnInfo, int dataTypeMappingFlags) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                if (columnInfo.getLength() == 1L) {
                    return this.row.buf[this.row.pos] != 0;
                }
                byte[] dataBit = new byte[this.row.length];
                System.arraycopy(this.row.buf, this.row.pos, dataBit, 0, this.row.length);
                return dataBit;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && columnInfo.getLength() == 1L) {
                    if (!this.isBinaryEncoded) {
                        return this.row.buf[this.row.pos] != 48;
                    }
                    return this.row.buf[this.row.pos] != 0;
                }
                return this.getInternalInt(columnInfo);
            }
            case INTEGER: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalLong(columnInfo);
                }
                return this.getInternalInt(columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalBigInteger(columnInfo);
                }
                return this.getInternalLong(columnInfo);
            }
            case DOUBLE: {
                return this.getInternalDouble(columnInfo);
            }
            case VARCHAR: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.row.getLengthMaxFieldSize()];
                    System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getInternalTimestamp(columnInfo, null);
            }
            case DATE: {
                return this.getInternalDate(columnInfo, null);
            }
            case DECIMAL: {
                return this.getInternalBigDecimal(columnInfo);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                byte[] dataBlob = new byte[this.row.getLengthMaxFieldSize()];
                System.arraycopy(this.row.buf, this.row.pos, dataBlob, 0, this.row.getLengthMaxFieldSize());
                return dataBlob;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((dataTypeMappingFlags & 2) != 0) {
                    return this.getInternalDate(columnInfo, null);
                }
                return this.getInternalShort(columnInfo);
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInternalInt(columnInfo);
            }
            case FLOAT: {
                return Float.valueOf(this.getInternalFloat(columnInfo));
            }
            case TIME: {
                return this.getInternalTime(columnInfo, null);
            }
            case STRING: 
            case VARSTRING: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.row.getLengthMaxFieldSize()];
                    System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo);
            }
            case OLDDECIMAL: {
                return this.getInternalString(columnInfo);
            }
            case GEOMETRY: {
                byte[] data = new byte[this.row.length];
                System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.length);
                return data;
            }
            case ENUM: {
                break;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
        }
        throw ExceptionMapper.getFeatureNotSupportedException("Type '" + columnInfo.getColumnType().getTypeName() + "' is not supported");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.columnNameMap.getIndex(columnLabel) + 1;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        String value = this.getInternalString(this.columnsInformation[columnIndex - 1]);
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Getting REFs not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        byte[] data = new byte[this.row.getLengthMaxFieldSize()];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
        return new MariaDbBlob(data);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        byte[] data = new byte[this.row.getLengthMaxFieldSize()];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
        return new MariaDbClob(data);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        try {
            return new URL(this.getInternalString(this.columnsInformation[columnIndex - 1]));
        }
        catch (MalformedURLException e) {
            throw ExceptionMapper.getSqlException("Could not parse as URL");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.lastValueWasNull()) {
            return null;
        }
        byte[] data = new byte[this.row.getLengthMaxFieldSize()];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
        return new MariaDbClob(data);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.checkObjectRange(index);
        return this.getInternalBoolean(this.columnsInformation[index - 1]);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int index) throws SQLException {
        this.checkObjectRange(index);
        return this.getInternalByte(this.columnsInformation[index - 1]);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int index) throws SQLException {
        this.checkObjectRange(index);
        return this.getInternalShort(this.columnsInformation[index - 1]);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting row updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting inserts are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Row deletes are not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("insertRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("deleteRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("refreshRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateByte(String columnLabel, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateShort(String columnLabel, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateInt(String columnLabel, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateFloat(String columnLabel, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDouble(String columnLabel, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateString(String columnLabel, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDate(String columnLabel, Date value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTime(String columnLabel, Time value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(String columnLabel, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(String columnLabel, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateLong(String columnLabel, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("updateRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNString(int columnIndex, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNString(String columnLabel, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    private boolean getInternalBoolean(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return false;
        }
        if (!this.isBinaryEncoded) {
            if (this.row.length == 1 && this.row.buf[this.row.pos] == 0) {
                return false;
            }
            String rawVal = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            return !"false".equals(rawVal) && !"0".equals(rawVal);
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos] != 0;
            }
            case TINYINT: {
                return this.getInternalTinyInt(columnInfo) != 0;
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt(columnInfo) != 0;
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt(columnInfo) != 0L;
            }
            case BIGINT: {
                return this.getInternalLong(columnInfo) != 0L;
            }
            case FLOAT: {
                return this.getInternalFloat(columnInfo) != 0.0f;
            }
            case DOUBLE: {
                return this.getInternalDouble(columnInfo) != 0.0;
            }
        }
        String rawVal = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
        return !"false".equals(rawVal) && !"0".equals(rawVal);
    }

    private byte getInternalByte(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            if (columnInfo.getColumnType() == ColumnType.BIT) {
                return this.row.buf[this.row.pos];
            }
            return this.parseByte(columnInfo);
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos];
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                value = this.getInternalLong(columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getInternalFloat(columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getInternalDouble(columnInfo);
                break;
            }
            default: {
                return this.parseByte(columnInfo);
            }
        }
        this.rangeCheck(Byte.class, -128L, 127L, value, columnInfo);
        return (byte)value;
    }

    private short getInternalShort(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            return this.parseShort(columnInfo);
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.row.buf[this.row.pos];
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = (this.row.buf[this.row.pos] & 0xFF) + ((this.row.buf[this.row.pos + 1] & 0xFF) << 8);
                if (columnInfo.isSigned()) {
                    return (short)value;
                }
                value &= 0xFFFFL;
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                value = this.getInternalLong(columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getInternalFloat(columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getInternalDouble(columnInfo);
                break;
            }
            default: {
                return this.parseShort(columnInfo);
            }
        }
        this.rangeCheck(Short.class, -32768L, 32767L, value, columnInfo);
        return (short)value;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public void setReturnTableAlias(boolean returnTableAlias) {
        this.returnTableAlias = returnTableAlias;
    }

    private String getTimeString(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.row.length == 0) {
            if (columnInfo.getDecimals() == 0) {
                return "00:00:00";
            }
            StringBuilder value = new StringBuilder("00:00:00.");
            int decimal = columnInfo.getDecimals();
            while (decimal-- > 0) {
                value.append("0");
            }
            return value.toString();
        }
        String rawValue = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            if (this.options.maximizeMysqlCompatibility && this.options.useLegacyDatetimeCode && rawValue.indexOf(".") > 0) {
                return rawValue.substring(0, rawValue.indexOf("."));
            }
            return rawValue;
        }
        byte hour = this.row.buf[this.row.pos + 5];
        int day = this.row.buf[this.row.pos + 1] & 0xFF | (this.row.buf[this.row.pos + 2] & 0xFF) << 8 | (this.row.buf[this.row.pos + 3] & 0xFF) << 16 | (this.row.buf[this.row.pos + 4] & 0xFF) << 24;
        int timeHour = hour + day * 24;
        String hourString = timeHour < 10 ? "0" + timeHour : Integer.toString(timeHour);
        byte minutes = this.row.buf[this.row.pos + 6];
        String minuteString = minutes < 10 ? "0" + minutes : Integer.toString(minutes);
        byte seconds = this.row.buf[this.row.pos + 7];
        String secondString = seconds < 10 ? "0" + seconds : Integer.toString(seconds);
        int microseconds = 0;
        if (this.row.length > 8) {
            microseconds = this.row.buf[this.row.pos + 8] & 0xFF | (this.row.buf[this.row.pos + 9] & 0xFF) << 8 | (this.row.buf[this.row.pos + 10] & 0xFF) << 16 | (this.row.buf[this.row.pos + 11] & 0xFF) << 24;
        }
        StringBuilder microsecondString = new StringBuilder(Integer.toString(microseconds));
        while (microsecondString.length() < 6) {
            microsecondString.insert(0, "0");
        }
        boolean negative = this.row.buf[this.row.pos] == 1;
        return (negative ? "-" : "") + hourString + ":" + minuteString + ":" + secondString + "." + microsecondString;
    }

    private void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnInformation columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    private int getInternalTinyInt(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = this.row.buf[this.row.pos];
        if (!columnInfo.isSigned()) {
            value = this.row.buf[this.row.pos] & 0xFF;
        }
        return value;
    }

    private int getInternalSmallInt(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = (this.row.buf[this.row.pos] & 0xFF) + ((this.row.buf[this.row.pos + 1] & 0xFF) << 8);
        if (!columnInfo.isSigned()) {
            return value & 0xFFFF;
        }
        return (short)value;
    }

    private long getInternalMediumInt(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        long value = (this.row.buf[this.row.pos] & 0xFF) + ((this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 24);
        if (!columnInfo.isSigned()) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    private byte parseByte(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        try {
            switch (columnInfo.getColumnType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(127.0f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Byte range", "22003", 1264);
                    }
                    return floatValue.byteValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(127.0) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Byte range", "22003", 1264);
                    }
                    return doubleValue.byteValue();
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case YEAR: {
                    long result = 0L;
                    int length = this.row.length;
                    boolean negate = false;
                    int begin = this.row.pos;
                    if (length > 0 && this.row.buf[begin] == 45) {
                        negate = true;
                        ++begin;
                    }
                    while (begin < this.row.pos + length) {
                        result = result * 10L + (long)this.row.buf[begin] - 48L;
                        ++begin;
                    }
                    result = negate ? -1L * result : result;
                    this.rangeCheck(Byte.class, -128L, 127L, result, columnInfo);
                    return (byte)result;
                }
            }
            return Byte.parseByte(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Byte.parseByte(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Byte range", "22003", 1264);
        }
    }

    private short parseShort(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        try {
            switch (columnInfo.getColumnType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(32767.0f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Short range", "22003", 1264);
                    }
                    return floatValue.shortValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(32767.0) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Short range", "22003", 1264);
                    }
                    return doubleValue.shortValue();
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case YEAR: {
                    long result = 0L;
                    int length = this.row.length;
                    boolean negate = false;
                    int begin = this.row.pos;
                    if (length > 0 && this.row.buf[begin] == 45) {
                        negate = true;
                        ++begin;
                    }
                    while (begin < this.row.pos + length) {
                        result = result * 10L + (long)this.row.buf[begin] - 48L;
                        ++begin;
                    }
                    result = negate ? -1L * result : result;
                    this.rangeCheck(Short.class, -32768L, 32767L, result, columnInfo);
                    return (short)result;
                }
            }
            return Short.parseShort(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Short.parseShort(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Short range", "22003", 1264);
        }
    }

    private int parseInt(ColumnInformation columnInfo) throws SQLException {
        try {
            switch (columnInfo.getColumnType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(2.1474836E9f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Integer range", "22003", 1264);
                    }
                    return floatValue.intValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(2.147483647E9) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Integer range", "22003", 1264);
                    }
                    return doubleValue.intValue();
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: 
                case YEAR: {
                    long result = 0L;
                    boolean negate = false;
                    int begin = this.row.pos;
                    if (this.row.length > 0 && this.row.buf[begin] == 45) {
                        negate = true;
                        ++begin;
                    }
                    while (begin < this.row.pos + this.row.length) {
                        result = result * 10L + (long)this.row.buf[begin] - 48L;
                        ++begin;
                    }
                    if (result < 0L) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Integer range", "22003", 1264);
                    }
                    result = negate ? -1L * result : result;
                    this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, result, columnInfo);
                    return (int)result;
                }
            }
            return Integer.parseInt(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Integer.parseInt(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Integer range", "22003", 1264);
        }
    }

    private long parseLong(ColumnInformation columnInfo) throws SQLException {
        try {
            switch (columnInfo.getColumnType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return floatValue.longValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return doubleValue.longValue();
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: 
                case YEAR: {
                    long result = 0L;
                    int length = this.row.length;
                    boolean negate = false;
                    int begin = this.row.pos;
                    if (length > 0 && this.row.buf[begin] == 45) {
                        negate = true;
                        ++begin;
                    }
                    while (begin < this.row.pos + length) {
                        result = result * 10L + (long)this.row.buf[begin] - 48L;
                        ++begin;
                    }
                    if (result < 0L) {
                        if (result == Long.MIN_VALUE && negate) {
                            return Long.MIN_VALUE;
                        }
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return negate ? -1L * result : result;
                }
            }
            return Long.parseLong(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Long.parseLong(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Long range", "22003", 1264);
        }
    }

    private BigInteger getInternalBigInteger(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigInteger(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigInteger.valueOf(this.row.buf[this.row.pos]);
            }
            case TINYINT: {
                return BigInteger.valueOf(columnInfo.isSigned() ? this.row.buf[this.row.pos] : this.row.buf[this.row.pos] & 0xFF);
            }
            case SMALLINT: 
            case YEAR: {
                int valueShort = this.row.buf[this.row.pos] & 0xFF | (this.row.buf[this.row.pos + 1] & 0xFF) << 8;
                return BigInteger.valueOf(columnInfo.isSigned() ? valueShort : valueShort & 0xFFFF);
            }
            case INTEGER: 
            case MEDIUMINT: {
                int valueInt = (this.row.buf[this.row.pos] & 0xFF) + ((this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 24);
                return BigInteger.valueOf(columnInfo.isSigned() ? (long)valueInt : (valueInt >= 0 ? (long)valueInt : (long)valueInt & 0xFFFFFFFFL));
            }
            case BIGINT: {
                long value = (long)(this.row.buf[this.row.pos] & 0xFF) + ((long)(this.row.buf[this.row.pos + 1] & 0xFF) << 8) + ((long)(this.row.buf[this.row.pos + 2] & 0xFF) << 16) + ((long)(this.row.buf[this.row.pos + 3] & 0xFF) << 24) + ((long)(this.row.buf[this.row.pos + 4] & 0xFF) << 32) + ((long)(this.row.buf[this.row.pos + 5] & 0xFF) << 40) + ((long)(this.row.buf[this.row.pos + 6] & 0xFF) << 48) + ((long)(this.row.buf[this.row.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return BigInteger.valueOf(value);
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getInternalFloat(columnInfo));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getInternalDouble(columnInfo));
            }
        }
        return new BigInteger(new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date binaryDate(ColumnInformation columnInfo, Calendar cal) throws SQLException {
        Date dt;
        Calendar calendar;
        switch (columnInfo.getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal);
                return timestamp == null ? null : new Date(timestamp.getTime());
            }
            case TIME: {
                throw new SQLException("Cannot read Date using a Types.TIME field");
            }
        }
        if (this.row.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        int year = this.row.buf[this.row.pos] & 0xFF | (this.row.buf[this.row.pos + 1] & 0xFF) << 8;
        if (this.row.length == 2 && columnInfo.getLength() == 2L) {
            year = year <= 69 ? (year += 2000) : (year += 1900);
        }
        byte month = 1;
        byte day = 1;
        if (this.row.length >= 4) {
            month = this.row.buf[this.row.pos + 2];
            day = this.row.buf[this.row.pos + 3];
        }
        Calendar calendar2 = calendar = Calendar.getInstance();
        synchronized (calendar2) {
            calendar.clear();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dt = new Date(calendar.getTimeInMillis());
        }
        return dt;
    }

    private Time binaryTime(ColumnInformation columnInfo, Calendar cal) throws SQLException {
        switch (columnInfo.getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp ts = this.binaryTimestamp(columnInfo, cal);
                return ts == null ? null : new Time(ts.getTime());
            }
            case DATE: {
                throw new SQLException("Cannot read Time using a Types.DATE field");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int day = 0;
        byte hour = 0;
        int minutes = 0;
        int seconds = 0;
        boolean negate = false;
        if (this.row.length > 0) {
            boolean bl = negate = (this.row.buf[this.row.pos] & 0xFF) == 1;
        }
        if (this.row.length > 4) {
            day = (this.row.buf[this.row.pos + 1] & 0xFF) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 4] & 0xFF) << 24);
        }
        if (this.row.length > 7) {
            hour = this.row.buf[this.row.pos + 5];
            minutes = this.row.buf[this.row.pos + 6];
            seconds = this.row.buf[this.row.pos + 7];
        }
        calendar.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
        int nanoseconds = 0;
        if (this.row.length > 8) {
            nanoseconds = (this.row.buf[this.row.pos + 8] & 0xFF) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 11] & 0xFF) << 24);
        }
        calendar.set(14, nanoseconds / 1000);
        return new Time(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp binaryTimestamp(ColumnInformation columnInfo, Calendar userCalendar) {
        Timestamp tt;
        if (this.row.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        int day = 0;
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        int microseconds = 0;
        if (columnInfo.getColumnType() == ColumnType.TIME) {
            Timestamp tt2;
            Calendar calendar = userCalendar != null ? userCalendar : Calendar.getInstance();
            boolean negate = false;
            if (this.row.length > 0) {
                boolean bl = negate = (this.row.buf[this.row.pos] & 0xFF) == 1;
            }
            if (this.row.length > 4) {
                day = (this.row.buf[this.row.pos + 1] & 0xFF) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 4] & 0xFF) << 24);
            }
            if (this.row.length > 7) {
                hour = this.row.buf[this.row.pos + 5];
                minutes = this.row.buf[this.row.pos + 6];
                seconds = this.row.buf[this.row.pos + 7];
            }
            if (this.row.length > 8) {
                microseconds = (this.row.buf[this.row.pos + 8] & 0xFF) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 11] & 0xFF) << 24);
            }
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.clear();
                calendar.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
                tt2 = new Timestamp(calendar.getTimeInMillis());
            }
            tt2.setNanos(microseconds * 1000);
            return tt2;
        }
        int year = this.row.buf[this.row.pos] & 0xFF | (this.row.buf[this.row.pos + 1] & 0xFF) << 8;
        byte month = this.row.buf[this.row.pos + 2];
        day = this.row.buf[this.row.pos + 3];
        if (this.row.length > 4) {
            hour = this.row.buf[this.row.pos + 4];
            minutes = this.row.buf[this.row.pos + 5];
            seconds = this.row.buf[this.row.pos + 6];
            if (this.row.length > 7) {
                microseconds = (this.row.buf[this.row.pos + 7] & 0xFF) + ((this.row.buf[this.row.pos + 8] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 24);
            }
        }
        Calendar calendar = userCalendar != null ? userCalendar : (columnInfo.getColumnType().getSqlType() == 93 ? Calendar.getInstance(this.timeZone) : Calendar.getInstance());
        Calendar calendar3 = calendar;
        synchronized (calendar3) {
            calendar.clear();
            calendar.set(year, month - 1, day, hour, minutes, seconds);
            tt = new Timestamp(calendar.getTimeInMillis());
        }
        tt.setNanos(microseconds * 1000);
        return tt;
    }

    private int extractNanos(String timestring) throws SQLException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new SQLException("cannot parse sub-second part in timestamp string '" + timestring + "'");
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    private ZonedDateTime getZonedDateTime(ColumnInformation columnInfo, Class clazz) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.row.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if (!this.isBinaryEncoded) {
            String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    if (raw.startsWith("0000-00-00 00:00:00")) {
                        return null;
                    }
                    try {
                        LocalDateTime localDateTime = LocalDateTime.parse(raw, TEXT_LOCAL_DATE_TIME.withZone(this.timeZone.toZoneId()));
                        return ZonedDateTime.of(localDateTime, this.timeZone.toZoneId());
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as LocalDateTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    if (raw.startsWith("0000-00-00 00:00:00")) {
                        return null;
                    }
                    try {
                        return ZonedDateTime.parse(raw, TEXT_ZONED_DATE_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                    }
                }
            }
            throw new SQLException("Cannot read " + clazz.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 93: {
                int year = this.row.buf[this.row.pos] & 0xFF | (this.row.buf[this.row.pos + 1] & 0xFF) << 8;
                byte month = this.row.buf[this.row.pos + 2];
                byte day = this.row.buf[this.row.pos + 3];
                byte hour = 0;
                int minutes = 0;
                int seconds = 0;
                int microseconds = 0;
                if (this.row.length > 4) {
                    hour = this.row.buf[this.row.pos + 4];
                    minutes = this.row.buf[this.row.pos + 5];
                    seconds = this.row.buf[this.row.pos + 6];
                    if (this.row.length > 7) {
                        microseconds = (this.row.buf[this.row.pos + 7] & 0xFF) + ((this.row.buf[this.row.pos + 8] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 24);
                    }
                }
                return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, this.timeZone.toZoneId());
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                if (raw.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse(raw, TEXT_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
        }
        throw new SQLException("Cannot read " + clazz.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    private OffsetTime getOffsetTime(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.row.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        ZoneId zoneId = this.timeZone.toZoneId().normalized();
        if (ZoneOffset.class.isInstance(zoneId)) {
            ZoneOffset zoneOffset = (ZoneOffset)ZoneOffset.class.cast(zoneId);
            if (!this.isBinaryEncoded) {
                String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                switch (columnInfo.getColumnType().getSqlType()) {
                    case 93: {
                        if (raw.startsWith("0000-00-00 00:00:00")) {
                            return null;
                        }
                        try {
                            return ZonedDateTime.parse(raw, TEXT_LOCAL_DATE_TIME.withZone(zoneOffset)).toOffsetDateTime().toOffsetTime();
                        }
                        catch (DateTimeParseException dateParserEx) {
                            throw new SQLException(raw + " cannot be parse as OffsetTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                        }
                    }
                    case 92: {
                        try {
                            LocalTime localTime = LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(zoneOffset));
                            return OffsetTime.of(localTime, zoneOffset);
                        }
                        catch (DateTimeParseException dateParserEx) {
                            throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                        }
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                        }
                        catch (DateTimeParseException dateParserEx) {
                            throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                        }
                    }
                }
                throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
            }
            int day = 0;
            byte hour = 0;
            byte minutes = 0;
            int seconds = 0;
            int microseconds = 0;
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    int year = this.row.buf[this.row.pos] & 0xFF | (this.row.buf[this.row.pos + 1] & 0xFF) << 8;
                    byte month = this.row.buf[this.row.pos + 2];
                    day = this.row.buf[this.row.pos + 3];
                    if (this.row.length > 4) {
                        hour = this.row.buf[this.row.pos + 4];
                        minutes = this.row.buf[this.row.pos + 5];
                        seconds = this.row.buf[this.row.pos + 6];
                        if (this.row.length > 7) {
                            microseconds = (this.row.buf[this.row.pos + 7] & 0xFF) + ((this.row.buf[this.row.pos + 8] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 24);
                        }
                    }
                    return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, zoneOffset).toOffsetDateTime().toOffsetTime();
                }
                case 92: {
                    boolean negate;
                    boolean bl = negate = (this.row.buf[this.row.pos] & 0xFF) == 1;
                    if (this.row.length > 4) {
                        day = (this.row.buf[this.row.pos + 1] & 0xFF) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 4] & 0xFF) << 24);
                    }
                    if (this.row.length > 7) {
                        hour = this.row.buf[this.row.pos + 5];
                        minutes = this.row.buf[this.row.pos + 6];
                        seconds = this.row.buf[this.row.pos + 7];
                    }
                    if (this.row.length > 8) {
                        microseconds = (this.row.buf[this.row.pos + 8] & 0xFF) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 11] & 0xFF) << 24);
                    }
                    return OffsetTime.of((negate ? -1 : 1) * (day * 24 + hour), minutes, seconds, microseconds * 1000, zoneOffset);
                }
                case -1: 
                case 1: 
                case 12: {
                    String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                    try {
                        return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    private LocalTime getLocalTime(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.row.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if (!this.isBinaryEncoded) {
            String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            switch (columnInfo.getColumnType().getSqlType()) {
                case -1: 
                case 1: 
                case 12: 
                case 92: {
                    try {
                        return LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(this.timeZone.toZoneId()));
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
                case 93: {
                    ZonedDateTime zonedDateTime = this.getZonedDateTime(columnInfo, LocalTime.class);
                    return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
                }
            }
            throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 92: {
                boolean negate;
                int day = 0;
                byte hour = 0;
                byte minutes = 0;
                int seconds = 0;
                int microseconds = 0;
                boolean bl = negate = (this.row.buf[this.row.pos] & 0xFF) == 1;
                if (this.row.length > 4) {
                    day = (this.row.buf[this.row.pos + 1] & 0xFF) + ((this.row.buf[this.row.pos + 2] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 3] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 4] & 0xFF) << 24);
                }
                if (this.row.length > 7) {
                    hour = this.row.buf[this.row.pos + 5];
                    minutes = this.row.buf[this.row.pos + 6];
                    seconds = this.row.buf[this.row.pos + 7];
                }
                if (this.row.length > 8) {
                    microseconds = (this.row.buf[this.row.pos + 8] & 0xFF) + ((this.row.buf[this.row.pos + 9] & 0xFF) << 8) + ((this.row.buf[this.row.pos + 10] & 0xFF) << 16) + ((this.row.buf[this.row.pos + 11] & 0xFF) << 24);
                }
                return LocalTime.of((negate ? -1 : 1) * (day * 24 + hour), minutes, seconds, microseconds * 1000);
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                try {
                    return LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(this.timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getZonedDateTime(columnInfo, LocalTime.class);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    private LocalDate getLocalDate(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.row.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if (!this.isBinaryEncoded) {
            String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
            switch (columnInfo.getColumnType().getSqlType()) {
                case -1: 
                case 1: 
                case 12: 
                case 91: {
                    if (raw.startsWith("0000-00-00")) {
                        return null;
                    }
                    try {
                        return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE.withZone(this.timeZone.toZoneId()));
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as LocalDate (format is \"yyyy-MM-dd\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
                case 93: {
                    ZonedDateTime zonedDateTime = this.getZonedDateTime(columnInfo, LocalDate.class);
                    return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
                }
            }
            throw new SQLException("Cannot read LocalDate using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 91: {
                int year = this.row.buf[this.row.pos] & 0xFF | (this.row.buf[this.row.pos + 1] & 0xFF) << 8;
                byte month = this.row.buf[this.row.pos + 2];
                byte day = this.row.buf[this.row.pos + 3];
                return LocalDate.of(year, month, (int)day);
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getZonedDateTime(columnInfo, LocalDate.class);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.row.buf, this.row.pos, this.row.length, StandardCharsets.UTF_8);
                if (raw.startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE.withZone(this.timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalDate. time must have \"yyyy-MM-dd\" format");
                }
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    public int getRowPointer() {
        return this.rowPointer;
    }

    protected void setRowPointer(int pointer) {
        this.rowPointer = pointer;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    static {
        isIntegerRegex = Pattern.compile("^-?\\d+\\.[0-9]+$");
        INSERT_ID_COLUMNS = new ColumnInformation[1];
        SelectResultSet.INSERT_ID_COLUMNS[0] = ColumnInformation.create("insert_id", ColumnType.BIGINT);
        TEXT_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
        TEXT_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(TEXT_LOCAL_DATE_TIME).appendOffsetId().toFormatter();
        TEXT_ZONED_DATE_TIME = new DateTimeFormatterBuilder().append(TEXT_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    }
}

