/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.compiler.CompiledAccExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class AssignmentNode
extends ASTNode
implements Assignment {
    private String varName;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private String index;
    private char[] stmt;
    private ExecutableStatement statement;
    private boolean col = false;

    public AssignmentNode(char[] expr, int fields, ParserContext pCtx) {
        this.name = expr;
        int assignStart = ParseTools.find(expr, '=');
        if (assignStart != -1) {
            this.varName = ParseTools.createStringTrimmed(expr, 0, assignStart);
            this.stmt = ParseTools.subset(expr, assignStart + 1);
            if ((fields & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
                this.egressType = this.statement.getKnownEgressType();
            }
            if (this.col = (this.endOfName = ArrayTools.findFirst('[', this.indexTarget = this.varName.toCharArray())) > 0) {
                if (((this.fields |= 0x1000) & 0x10) != 0) {
                    this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, pCtx);
                }
                this.varName = new String(expr, 0, this.endOfName);
                this.index = new String(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
            }
            ParseTools.checkNameSafety(this.varName);
        } else {
            this.varName = new String(expr);
            ParseTools.checkNameSafety(this.varName);
        }
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(this.varName, this.egressType);
        }
        this.name = this.varName.toCharArray();
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accExpr == null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            return this.accExpr.setValue(ctx, thisValue, factory, this.statement.getValue(ctx, thisValue, factory));
        }
        if (this.statement != null) {
            return factory.createVariable(this.varName, this.statement.getValue(ctx, thisValue, factory)).getValue();
        }
        factory.createVariable(this.varName, null);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ParseTools.checkNameSafety(this.varName);
        if (!this.col) {
            return factory.createVariable(this.varName, MVEL.eval(this.stmt, ctx, factory)).getValue();
        }
        ctx = MVEL.eval(this.stmt, ctx, factory);
        PropertyAccessor.set(factory.getVariableResolver(this.varName).getValue(), factory, this.index, ctx);
        return ctx;
    }

    public String getAssignmentVar() {
        return this.varName;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

