/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.fescar.aop.trans;

import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.common.util.StringUtils;
import com.alibaba.fescar.spring.annotation.GlobalTransactional;
import com.alibaba.fescar.tm.api.DefaultFailureHandlerImpl;
import com.alibaba.fescar.tm.api.FailureHandler;
import com.alibaba.fescar.tm.api.TransactionalExecutor;
import com.alibaba.fescar.tm.api.TransactionalTemplate;
import java.lang.reflect.Method;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.lang.Lang;

public class FescarTransInterceptor
implements MethodInterceptor {
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final FailureHandler failureHandler;
    private GlobalTransactional globalTrxAnno;
    private String name;

    public FescarTransInterceptor(FailureHandler failureHandler, GlobalTransactional globalTrxAnno, Method method) {
        if (null == failureHandler) {
            failureHandler = DEFAULT_FAIL_HANDLER;
        }
        this.failureHandler = failureHandler;
        this.globalTrxAnno = globalTrxAnno;
        String name = globalTrxAnno.name();
        this.name = !StringUtils.isNullOrEmpty((String)name) ? name : Lang.simpleMethodDesc((Method)method);
    }

    public void filter(final InterceptorChain chain) throws Throwable {
        try {
            this.transactionalTemplate.execute(new TransactionalExecutor(){

                public Object execute() throws Throwable {
                    return chain.doChain();
                }

                public int timeout() {
                    return FescarTransInterceptor.this.globalTrxAnno.timeoutMills();
                }

                public String name() {
                    return FescarTransInterceptor.this.name;
                }
            });
        }
        catch (TransactionalExecutor.ExecutionException e) {
            TransactionalExecutor.Code code = e.getCode();
            switch (code) {
                case RollbackDone: {
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    this.failureHandler.onBeginFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case CommitFailure: {
                    this.failureHandler.onCommitFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
            }
            throw new ShouldNeverHappenException("Unknown TransactionalExecutor.Code: " + code);
        }
    }
}

