/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractDecompressingPostProcessor
implements MessagePostProcessor,
Ordered {
    private final boolean alwaysDecompress;
    private int order;

    public AbstractDecompressingPostProcessor() {
        this(false);
    }

    public AbstractDecompressingPostProcessor(boolean alwaysDecompress) {
        this.alwaysDecompress = alwaysDecompress;
    }

    public int getOrder() {
        return this.order;
    }

    protected void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Message postProcessMessage(Message message) throws AmqpException {
        Object autoDecompress = message.getMessageProperties().getHeaders().get("springAutoDecompress");
        if (this.alwaysDecompress || autoDecompress instanceof Boolean && ((Boolean)autoDecompress).booleanValue()) {
            ByteArrayInputStream zipped = new ByteArrayInputStream(message.getBody());
            try {
                InputStream unzipper = this.getDecompressorStream(zipped);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)unzipper, (OutputStream)out);
                MessageProperties messageProperties = message.getMessageProperties();
                String encoding = messageProperties.getContentEncoding();
                int colonAt = encoding.indexOf(":");
                if (colonAt > 0) {
                    encoding = encoding.substring(0, colonAt);
                }
                Assert.state((boolean)this.getEncoding().equals(encoding), (String)("Content encoding must be:" + this.getEncoding() + ", was:" + encoding));
                if (colonAt < 0) {
                    messageProperties.setContentEncoding(null);
                } else {
                    messageProperties.setContentEncoding(messageProperties.getContentEncoding().substring(colonAt + 1));
                }
                messageProperties.getHeaders().remove("springAutoDecompress");
                return new Message(out.toByteArray(), messageProperties);
            }
            catch (IOException e) {
                throw new AmqpIOException(e);
            }
        }
        return message;
    }

    protected abstract InputStream getDecompressorStream(InputStream var1) throws IOException;

    protected abstract String getEncoding();
}

