/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.ldif.builder;

import org.springframework.batch.item.ldif.LdifReader;
import org.springframework.batch.item.ldif.RecordCallbackHandler;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LdifReaderBuilder {
    private Resource resource;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private RecordCallbackHandler skippedRecordsCallback;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public LdifReaderBuilder saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public LdifReaderBuilder name(String name) {
        this.name = name;
        return this;
    }

    public LdifReaderBuilder maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public LdifReaderBuilder currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public LdifReaderBuilder strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public LdifReaderBuilder skippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
        return this;
    }

    public LdifReaderBuilder recordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
        return this;
    }

    public LdifReaderBuilder resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public LdifReader build() {
        Assert.notNull((Object)this.resource, (String)"Resource is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        LdifReader reader = new LdifReader();
        reader.setResource(this.resource);
        reader.setRecordsToSkip(this.recordsToSkip);
        reader.setSaveState(this.saveState);
        reader.setName(this.name);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        if (this.skippedRecordsCallback != null) {
            reader.setSkippedRecordsCallback(this.skippedRecordsCallback);
        }
        reader.setStrict(this.strict);
        return reader;
    }
}

