/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public abstract class AbstractQueryCreator<T, S> {
    private final ParameterAccessor parameters;
    private final PartTree tree;

    public AbstractQueryCreator(PartTree tree, ParameterAccessor parameters) {
        Assert.notNull((Object)tree, (String)"PartTree must not be null");
        this.tree = tree;
        this.parameters = parameters;
    }

    public AbstractQueryCreator(PartTree tree) {
        this(tree, null);
    }

    public T createQuery() {
        Sort dynamicSort = this.parameters != null ? this.parameters.getSort() : null;
        return this.createQuery(dynamicSort);
    }

    public T createQuery(Sort dynamicSort) {
        Sort staticSort = this.tree.getSort();
        Sort sort = staticSort != null ? staticSort.and(dynamicSort) : dynamicSort;
        return this.complete(this.createCriteria(this.tree), sort);
    }

    private S createCriteria(PartTree tree) {
        S base = null;
        Iterator<Object> iterator = this.parameters == null ? null : this.parameters.iterator();
        for (PartTree.OrPart node : tree) {
            S criteria = null;
            for (Part part : node) {
                criteria = (S)(criteria == null ? this.create(part, iterator) : this.and(part, criteria, iterator));
            }
            base = base == null ? criteria : this.or(base, criteria);
        }
        return base;
    }

    protected abstract S create(Part var1, Iterator<Object> var2);

    protected abstract S and(Part var1, S var2, Iterator<Object> var3);

    protected abstract S or(S var1, S var2);

    protected abstract T complete(S var1, Sort var2);
}

