/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.convert.DateTimeConverters;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;

public class ElasticsearchStringQuery
extends AbstractElasticsearchRepositoryQuery {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private String query;
    private final GenericConversionService conversionService = new GenericConversionService();

    public ElasticsearchStringQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations, String query) {
        super(queryMethod, elasticsearchOperations);
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (ClassUtils.isPresent((String)"org.joda.time.DateTimeZone", (ClassLoader)ElasticsearchStringQuery.class.getClassLoader())) {
            if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
        Assert.notNull((Object)query, (String)"Query cannot be empty");
        this.query = query;
    }

    @Override
    public boolean isCountQuery() {
        return this.queryMethod.hasCountQueryAnnotation();
    }

    public Object execute(Object[] parameters) {
        Class clazz = this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        StringQuery stringQuery = this.createQuery(accessor);
        Assert.notNull((Object)stringQuery, (String)"unsupported query");
        if (this.queryMethod.hasAnnotatedHighlight()) {
            stringQuery.setHighlightQuery(this.queryMethod.getAnnotatedHighlightQuery());
        }
        IndexCoordinates index = this.elasticsearchOperations.getIndexCoordinatesFor(clazz);
        Object result = null;
        if (this.isCountQuery()) {
            result = this.elasticsearchOperations.count(stringQuery, clazz, index);
        } else if (this.queryMethod.isPageQuery()) {
            stringQuery.setPageable(accessor.getPageable());
            SearchHits searchHits = this.elasticsearchOperations.search(stringQuery, clazz, index);
            result = SearchHitSupport.searchPageFor(searchHits, stringQuery.getPageable());
        } else if (this.queryMethod.isStreamQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                stringQuery.setPageable((Pageable)PageRequest.of((int)0, (int)500));
            } else {
                stringQuery.setPageable(accessor.getPageable());
            }
            result = StreamUtils.createStreamFromIterator(this.elasticsearchOperations.searchForStream(stringQuery, clazz, index));
        } else if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isPaged()) {
                stringQuery.setPageable(accessor.getPageable());
            }
            result = this.elasticsearchOperations.search(stringQuery, clazz, index);
        } else {
            result = this.elasticsearchOperations.searchOne(stringQuery, clazz, index);
        }
        return this.queryMethod.isNotSearchHitMethod() ? SearchHitSupport.unwrapSearchHits(result) : result;
    }

    protected StringQuery createQuery(ParametersParameterAccessor parameterAccessor) {
        String queryString = this.replacePlaceholders(this.query, parameterAccessor);
        return new StringQuery(queryString);
    }

    private String replacePlaceholders(String input, ParametersParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String placeholder = Pattern.quote(matcher.group()) + "(?!\\d+)";
            int index = (Integer)NumberUtils.parseNumber((String)matcher.group(1), Integer.class);
            result = result.replaceAll(placeholder, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    private String getParameterWithIndex(ParametersParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        if (parameter == null) {
            return "null";
        }
        if (this.conversionService.canConvert(parameter.getClass(), String.class)) {
            return (String)this.conversionService.convert(parameter, String.class);
        }
        return parameter.toString();
    }
}

