/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractReactiveElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.parser.ElasticsearchQueryCreator;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class ReactivePartTreeElasticsearchQuery
extends AbstractReactiveElasticsearchRepositoryQuery {
    private final PartTree tree;

    public ReactivePartTreeElasticsearchQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations elasticsearchOperations) {
        super(queryMethod, elasticsearchOperations);
        ResultProcessor processor = queryMethod.getResultProcessor();
        this.tree = new PartTree(queryMethod.getName(), processor.getReturnedType().getDomainType());
    }

    @Override
    protected BaseQuery createQuery(ElasticsearchParameterAccessor accessor) {
        CriteriaQuery query = (CriteriaQuery)new ElasticsearchQueryCreator(this.tree, accessor, this.getMappingContext()).createQuery();
        if (this.tree.isLimiting()) {
            query.setMaxResults(this.tree.getMaxResults());
        }
        return query;
    }

    @Override
    boolean isLimiting() {
        return this.tree.isLimiting();
    }

    @Override
    boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    boolean isCountQuery() {
        return this.tree.isCountProjection();
    }
}

