/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

class DBObjectAccessor {
    private final DBObject dbObject;

    public DBObjectAccessor(DBObject dbObject) {
        Assert.notNull((Object)dbObject, (String)"DBObject must not be null!");
        Assert.isInstanceOf(BasicDBObject.class, (Object)dbObject, (String)"Given DBObject must be a BasicDBObject!");
        this.dbObject = dbObject;
    }

    public void put(MongoPersistentProperty prop, Object value) {
        Assert.notNull((Object)prop, (String)"MongoPersistentProperty must not be null!");
        String fieldName = prop.getFieldName();
        Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
        DBObject dbObject = this.dbObject;
        while (parts.hasNext()) {
            String part = parts.next();
            if (parts.hasNext()) {
                BasicDBObject nestedDbObject = new BasicDBObject();
                dbObject.put(part, (Object)nestedDbObject);
                dbObject = nestedDbObject;
                continue;
            }
            dbObject.put(part, value);
        }
    }

    public Object get(MongoPersistentProperty property) {
        String fieldName = property.getFieldName();
        Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
        Map<Object, Object> source = this.dbObject.toMap();
        Object result = null;
        while (source != null && parts.hasNext()) {
            result = source.get(parts.next());
            if (!parts.hasNext()) continue;
            source = this.getAsMap(result);
        }
        return result;
    }

    private Map<Object, Object> getAsMap(Object source) {
        if (source instanceof BasicDBObject) {
            return ((DBObject)source).toMap();
        }
        if (source instanceof Map) {
            return (Map)source;
        }
        return null;
    }
}

