/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.srp.SrpMessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;
import redis.client.RedisClient;
import redis.client.ReplyListener;

class SrpSubscription
extends AbstractSubscription {
    private final RedisClient client;
    private final ReplyListener listener;

    SrpSubscription(MessageListener listener, RedisClient client) {
        super(listener);
        this.client = client;
        this.listener = new SrpMessageListener(listener);
        client.addListener(this.listener);
    }

    protected void doClose() {
        this.client.unsubscribe((Object[])null);
        this.client.punsubscribe((Object[])null);
        this.client.removeListener(this.listener);
    }

    protected void doPsubscribe(byte[] ... patterns) {
        this.client.psubscribe((Object[])patterns);
    }

    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        if (all) {
            this.client.punsubscribe((Object[])null);
        } else {
            this.client.punsubscribe((Object[])patterns);
        }
    }

    protected void doSubscribe(byte[] ... channels) {
        this.client.subscribe((Object[])channels);
    }

    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        if (all) {
            this.client.unsubscribe((Object[])null);
        } else {
            this.client.unsubscribe((Object[])channels);
        }
    }
}

