/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.util.Map;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceStringCommands;
import org.springframework.util.Assert;

class LettuceClusterStringCommands
extends LettuceStringCommands {
    LettuceClusterStringCommands(LettuceClusterConnection connection) {
        super(connection);
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            return super.mSetNX(tuples);
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.setNX(entry.getKey(), entry.getValue()).booleanValue() || !result) continue;
            result = false;
        }
        return result;
    }
}

