/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveZSetCommands {
    default public Mono<Long> zAdd(ByteBuffer key, Double score, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)score, (String)"Score must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zAdd((Publisher<ZAddCommand>)Mono.just((Object)ZAddCommand.tuple(new DefaultTuple(ByteUtils.getBytes(value), score)).to(key))).next().map(resp -> ((Number)resp.getOutput()).longValue());
    }

    default public Mono<Long> zAdd(ByteBuffer key, Collection<? extends RedisZSetCommands.Tuple> tuples) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        return this.zAdd((Publisher<ZAddCommand>)Mono.just((Object)ZAddCommand.tuples(tuples).to(key))).next().map(resp -> ((Number)resp.getOutput()).longValue());
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZAddCommand, Number>> zAdd(Publisher<ZAddCommand> var1);

    default public Mono<Long> zRem(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zRem(key, Collections.singletonList(value));
    }

    default public Mono<Long> zRem(ByteBuffer key, Collection<ByteBuffer> values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        return this.zRem((Publisher<ZRemCommand>)Mono.just((Object)ZRemCommand.values(values).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemCommand, Long>> zRem(Publisher<ZRemCommand> var1);

    default public Mono<Double> zIncrBy(ByteBuffer key, Number increment, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)increment, (String)"Increment must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zIncrBy((Publisher<ZIncrByCommand>)Mono.just((Object)ZIncrByCommand.scoreOf(value).by(increment).storedWithin(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZIncrByCommand, Double>> zIncrBy(Publisher<ZIncrByCommand> var1);

    default public Mono<Long> zRank(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zRank((Publisher<ZRankCommand>)Mono.just((Object)ZRankCommand.indexOf(value).storedWithin(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> zRevRank(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zRank((Publisher<ZRankCommand>)Mono.just((Object)ZRankCommand.reverseIndexOf(value).storedWithin(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRankCommand, Long>> zRank(Publisher<ZRankCommand> var1);

    default public Flux<ByteBuffer> zRange(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.valuesWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRangeWithScores(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.valuesWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> zRevRange(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.reverseValuesWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRevRangeWithScores(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.reverseValuesWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRangeCommand, Flux<RedisZSetCommands.Tuple>>> zRange(Publisher<ZRangeCommand> var1);

    default public Flux<ByteBuffer> zRangeByScore(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<ByteBuffer> zRangeByScore(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRangeByScoreWithScores(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zRangeByScoreWithScores(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).withScores().from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> zRevRangeByScore(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<ByteBuffer> zRevRangeByScore(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).withScores().from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>> zRangeByScore(Publisher<ZRangeByScoreCommand> var1);

    default public Flux<RedisZSetCommands.Tuple> zScan(ByteBuffer key) {
        return this.zScan(key, ScanOptions.NONE);
    }

    default public Flux<RedisZSetCommands.Tuple> zScan(ByteBuffer key, ScanOptions options) {
        return this.zScan((Publisher<ReactiveRedisConnection.KeyScanCommand>)Mono.just((Object)ReactiveRedisConnection.KeyScanCommand.key(key).withOptions(options))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(it -> it);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<RedisZSetCommands.Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> var1);

    default public Mono<Long> zCount(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zCount((Publisher<ZCountCommand>)Mono.just((Object)ZCountCommand.scoresWithin(range).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZCountCommand, Long>> zCount(Publisher<ZCountCommand> var1);

    default public Mono<Long> zCard(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zCard((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Double> zScore(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zScore((Publisher<ZScoreCommand>)Mono.just((Object)ZScoreCommand.scoreOf(value).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZScoreCommand, Double>> zScore(Publisher<ZScoreCommand> var1);

    default public Mono<Long> zRemRangeByRank(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRemRangeByRank((Publisher<ZRemRangeByRankCommand>)Mono.just((Object)ZRemRangeByRankCommand.valuesWithin(range).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ZRemRangeByRankCommand> var1);

    default public Mono<Long> zRemRangeByScore(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRemRangeByScore((Publisher<ZRemRangeByScoreCommand>)Mono.just((Object)ZRemRangeByScoreCommand.scoresWithin(range).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ZRemRangeByScoreCommand> var1);

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets) {
        return this.zUnionStore(destinationKey, sets, Collections.emptyList());
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights) {
        return this.zUnionStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights) {
        return this.zUnionStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnionStore((Publisher<ZUnionStoreCommand>)Mono.just((Object)ZUnionStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnionStore((Publisher<ZUnionStoreCommand>)Mono.just((Object)ZUnionStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZUnionStoreCommand, Long>> zUnionStore(Publisher<ZUnionStoreCommand> var1);

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets) {
        return this.zInterStore(destinationKey, sets, Collections.emptyList());
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights) {
        return this.zInterStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights) {
        return this.zInterStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInterStore((Publisher<ZInterStoreCommand>)Mono.just((Object)ZInterStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInterStore((Publisher<ZInterStoreCommand>)Mono.just((Object)ZInterStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZInterStoreCommand, Long>> zInterStore(Publisher<ZInterStoreCommand> var1);

    default public Flux<ByteBuffer> zRangeByLex(ByteBuffer key, Range<String> range) {
        return this.zRangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public Flux<ByteBuffer> zRangeByLex(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByLex((Publisher<ZRangeByLexCommand>)Mono.just((Object)ZRangeByLexCommand.stringsWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> zRevRangeByLex(ByteBuffer key, Range<String> range) {
        return this.zRevRangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public Flux<ByteBuffer> zRevRangeByLex(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByLex((Publisher<ZRangeByLexCommand>)Mono.just((Object)ZRangeByLexCommand.reverseStringsWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ZRangeByLexCommand> var1);

    public static class ZRangeByLexCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<String> range;
        private final Sort.Direction direction;
        private final RedisZSetCommands.Limit limit;

        private ZRangeByLexCommand(@Nullable ByteBuffer key, Range<String> range, Sort.Direction direction, RedisZSetCommands.Limit limit) {
            super(key);
            this.range = range;
            this.direction = direction;
            this.limit = limit;
        }

        public static ZRangeByLexCommand stringsWithin(Range<String> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByLexCommand(null, range, Sort.Direction.ASC, RedisZSetCommands.Limit.unlimited());
        }

        public static ZRangeByLexCommand reverseStringsWithin(Range<String> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByLexCommand(null, range, Sort.Direction.DESC, RedisZSetCommands.Limit.unlimited());
        }

        public ZRangeByLexCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRangeByLexCommand(key, this.range, this.direction, this.limit);
        }

        public ZRangeByLexCommand limitTo(RedisZSetCommands.Limit limit) {
            Assert.notNull((Object)limit, (String)"Limit must not be null!");
            return new ZRangeByLexCommand(this.getKey(), this.range, this.direction, limit);
        }

        public Range<String> getRange() {
            return this.range;
        }

        public RedisZSetCommands.Limit getLimit() {
            return this.limit;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }
    }

    public static class ZInterStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> sourceKeys;
        private final List<Double> weights;
        @Nullable
        private final RedisZSetCommands.Aggregate aggregateFunction;

        private ZInterStoreCommand(ByteBuffer key, List<ByteBuffer> sourceKeys, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregate) {
            super(key);
            this.sourceKeys = sourceKeys;
            this.weights = weights;
            this.aggregateFunction = aggregate;
        }

        public static ZInterStoreCommand sets(List<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZInterStoreCommand(null, new ArrayList<ByteBuffer>(keys), Collections.emptyList(), null);
        }

        public ZInterStoreCommand applyWeights(List<Double> weights) {
            return new ZInterStoreCommand(this.getKey(), this.sourceKeys, weights, this.aggregateFunction);
        }

        public ZInterStoreCommand applyWeights(RedisZSetCommands.Weights weights) {
            return this.applyWeights(weights.toList());
        }

        public ZInterStoreCommand aggregateUsing(@Nullable RedisZSetCommands.Aggregate aggregateFunction) {
            return new ZInterStoreCommand(this.getKey(), this.sourceKeys, this.weights, aggregateFunction);
        }

        public ZInterStoreCommand storeAs(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZInterStoreCommand(key, this.sourceKeys, this.weights, this.aggregateFunction);
        }

        public List<ByteBuffer> getSourceKeys() {
            return this.sourceKeys;
        }

        public List<Double> getWeights() {
            return this.weights;
        }

        public Optional<RedisZSetCommands.Aggregate> getAggregateFunction() {
            return Optional.ofNullable(this.aggregateFunction);
        }
    }

    public static class ZUnionStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> sourceKeys;
        private final List<Double> weights;
        @Nullable
        private final RedisZSetCommands.Aggregate aggregateFunction;

        private ZUnionStoreCommand(@Nullable ByteBuffer key, List<ByteBuffer> sourceKeys, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregate) {
            super(key);
            this.sourceKeys = sourceKeys;
            this.weights = weights;
            this.aggregateFunction = aggregate;
        }

        public static ZUnionStoreCommand sets(List<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZUnionStoreCommand(null, new ArrayList<ByteBuffer>(keys), Collections.emptyList(), null);
        }

        public ZUnionStoreCommand applyWeights(List<Double> weights) {
            return new ZUnionStoreCommand(this.getKey(), this.sourceKeys, weights, this.aggregateFunction);
        }

        public ZUnionStoreCommand applyWeights(RedisZSetCommands.Weights weights) {
            return this.applyWeights(weights.toList());
        }

        public ZUnionStoreCommand aggregateUsing(@Nullable RedisZSetCommands.Aggregate aggregateFunction) {
            return new ZUnionStoreCommand(this.getKey(), this.sourceKeys, this.weights, aggregateFunction);
        }

        public ZUnionStoreCommand storeAs(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZUnionStoreCommand(key, this.sourceKeys, this.weights, this.aggregateFunction);
        }

        public List<ByteBuffer> getSourceKeys() {
            return this.sourceKeys;
        }

        public List<Double> getWeights() {
            return this.weights;
        }

        public Optional<RedisZSetCommands.Aggregate> getAggregateFunction() {
            return Optional.ofNullable(this.aggregateFunction);
        }
    }

    public static class ZRemRangeByScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Double> range;

        private ZRemRangeByScoreCommand(@Nullable ByteBuffer key, Range<Double> range) {
            super(key);
            this.range = range;
        }

        public static ZRemRangeByScoreCommand scoresWithin(Range<Double> range) {
            return new ZRemRangeByScoreCommand(null, range);
        }

        public ZRemRangeByScoreCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemRangeByScoreCommand(key, this.range);
        }

        public Range<Double> getRange() {
            return this.range;
        }
    }

    public static class ZRemRangeByRankCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Long> range;

        private ZRemRangeByRankCommand(ByteBuffer key, Range<Long> range) {
            super(key);
            this.range = range;
        }

        public static ZRemRangeByRankCommand valuesWithin(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRemRangeByRankCommand(null, range);
        }

        public ZRemRangeByRankCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemRangeByRankCommand(key, this.range);
        }

        public Range<Long> getRange() {
            return this.range;
        }
    }

    public static class ZScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;

        private ZScoreCommand(@Nullable ByteBuffer key, ByteBuffer value) {
            super(key);
            this.value = value;
        }

        public static ZScoreCommand scoreOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZScoreCommand(null, member);
        }

        public ZScoreCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZScoreCommand(key, this.value);
        }

        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static class ZCountCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Double> range;

        private ZCountCommand(@Nullable ByteBuffer key, Range<Double> range) {
            super(key);
            this.range = range;
        }

        public static ZCountCommand scoresWithin(Range<Double> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZCountCommand(null, range);
        }

        public ZCountCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZCountCommand(key, this.range);
        }

        public Range<Double> getRange() {
            return this.range;
        }
    }

    public static class ZRangeByScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Double> range;
        private final boolean withScores;
        private final Sort.Direction direction;
        @Nullable
        private final RedisZSetCommands.Limit limit;

        private ZRangeByScoreCommand(@Nullable ByteBuffer key, Range<Double> range, Sort.Direction direction, boolean withScores, @Nullable RedisZSetCommands.Limit limit) {
            super(key);
            this.range = range;
            this.withScores = withScores;
            this.direction = direction;
            this.limit = limit;
        }

        public static ZRangeByScoreCommand scoresWithin(Range<Double> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByScoreCommand(null, range, Sort.Direction.ASC, false, null);
        }

        public static ZRangeByScoreCommand reverseScoresWithin(Range<Double> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByScoreCommand(null, range, Sort.Direction.DESC, false, null);
        }

        public ZRangeByScoreCommand withScores() {
            return new ZRangeByScoreCommand(this.getKey(), this.range, this.direction, true, this.limit);
        }

        public ZRangeByScoreCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRangeByScoreCommand(key, this.range, this.direction, this.withScores, this.limit);
        }

        public ZRangeByScoreCommand limitTo(RedisZSetCommands.Limit limit) {
            Assert.notNull((Object)limit, (String)"Limit must not be null!");
            return new ZRangeByScoreCommand(this.getKey(), this.range, this.direction, this.withScores, limit);
        }

        public Range<Double> getRange() {
            return this.range;
        }

        public boolean isWithScores() {
            return this.withScores;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }

        public Optional<RedisZSetCommands.Limit> getLimit() {
            return Optional.ofNullable(this.limit);
        }
    }

    public static class ZRangeCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Long> range;
        private final boolean withScores;
        private final Sort.Direction direction;

        private ZRangeCommand(@Nullable ByteBuffer key, Range<Long> range, Sort.Direction direction, boolean withScores) {
            super(key);
            this.range = range;
            this.withScores = withScores;
            this.direction = direction;
        }

        public static ZRangeCommand valuesWithin(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeCommand(null, range, Sort.Direction.ASC, false);
        }

        public static ZRangeCommand reverseValuesWithin(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeCommand(null, range, Sort.Direction.DESC, false);
        }

        public ZRangeCommand withScores() {
            return new ZRangeCommand(this.getKey(), this.range, this.direction, true);
        }

        public ZRangeCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRangeCommand(key, this.range, this.direction, this.withScores);
        }

        public Range<Long> getRange() {
            return this.range;
        }

        public boolean isWithScores() {
            return this.withScores;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }
    }

    public static class ZRankCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;
        private final Sort.Direction direction;

        private ZRankCommand(@Nullable ByteBuffer key, ByteBuffer value, Sort.Direction direction) {
            super(key);
            this.value = value;
            this.direction = direction;
        }

        public static ZRankCommand indexOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZRankCommand(null, member, Sort.Direction.ASC);
        }

        public static ZRankCommand reverseIndexOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZRankCommand(null, member, Sort.Direction.DESC);
        }

        public ZRankCommand storedWithin(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRankCommand(key, this.value, this.direction);
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }
    }

    public static class ZIncrByCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;
        @Nullable
        private final Number increment;

        private ZIncrByCommand(@Nullable ByteBuffer key, ByteBuffer value, @Nullable Number increment) {
            super(key);
            this.value = value;
            this.increment = increment;
        }

        public static ZIncrByCommand scoreOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZIncrByCommand(null, member, null);
        }

        public ZIncrByCommand by(Number increment) {
            Assert.notNull((Object)increment, (String)"Increment must not be null!");
            return new ZIncrByCommand(this.getKey(), this.value, increment);
        }

        public ZIncrByCommand storedWithin(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZIncrByCommand(key, this.value, this.increment);
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        @Nullable
        public Number getIncrement() {
            return this.increment;
        }
    }

    public static class ZRemCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> values;

        private ZRemCommand(@Nullable ByteBuffer key, List<ByteBuffer> values) {
            super(key);
            this.values = values;
        }

        public static ZRemCommand values(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new ZRemCommand(null, Collections.singletonList(value));
        }

        public static ZRemCommand values(Collection<ByteBuffer> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            return new ZRemCommand(null, new ArrayList<ByteBuffer>(values));
        }

        public ZRemCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemCommand(key, this.values);
        }

        public List<ByteBuffer> getValues() {
            return this.values;
        }
    }

    public static class ZAddCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<RedisZSetCommands.Tuple> tuples;
        private final boolean upsert;
        private final boolean returnTotalChanged;
        private final boolean incr;

        private ZAddCommand(@Nullable ByteBuffer key, List<RedisZSetCommands.Tuple> tuples, boolean upsert, boolean returnTotalChanged, boolean incr) {
            super(key);
            this.tuples = tuples;
            this.upsert = upsert;
            this.returnTotalChanged = returnTotalChanged;
            this.incr = incr;
        }

        public static ZAddCommand tuple(RedisZSetCommands.Tuple tuple) {
            Assert.notNull((Object)tuple, (String)"Tuple must not be null!");
            return ZAddCommand.tuples(Collections.singletonList(tuple));
        }

        public static ZAddCommand tuples(Collection<? extends RedisZSetCommands.Tuple> tuples) {
            Assert.notNull(tuples, (String)"Tuples must not be null!");
            return new ZAddCommand(null, new ArrayList<RedisZSetCommands.Tuple>(tuples), false, false, false);
        }

        public ZAddCommand to(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZAddCommand(key, this.tuples, this.upsert, this.returnTotalChanged, this.incr);
        }

        public ZAddCommand xx() {
            return new ZAddCommand(this.getKey(), this.tuples, false, this.returnTotalChanged, this.incr);
        }

        public ZAddCommand nx() {
            return new ZAddCommand(this.getKey(), this.tuples, true, this.returnTotalChanged, this.incr);
        }

        public ZAddCommand ch() {
            return new ZAddCommand(this.getKey(), this.tuples, this.upsert, true, this.incr);
        }

        public ZAddCommand incr() {
            return new ZAddCommand(this.getKey(), this.tuples, this.upsert, this.upsert, true);
        }

        public List<RedisZSetCommands.Tuple> getTuples() {
            return this.tuples;
        }

        public boolean isUpsert() {
            return this.upsert;
        }

        public boolean isIncr() {
            return this.incr;
        }

        public boolean isReturnTotalChanged() {
            return this.returnTotalChanged;
        }
    }
}

