/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.json.MappedProperties;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;

public class JacksonMappingAwareSortTranslator {
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final Repositories repositories;
    @NonNull
    private final DomainClassResolver domainClassResolver;

    protected Sort translateSort(Sort input, MethodParameter parameter, NativeWebRequest webRequest) {
        Assert.notNull((Object)input, (String)"Sort must not be null!");
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
        Assert.notNull((Object)webRequest, (String)"NativeWebRequest must not be null!");
        Class<?> domainClass = this.domainClassResolver.resolve(parameter.getMethod(), webRequest);
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(domainClass);
        MappedProperties mappedProperties = MappedProperties.fromJacksonProperties(persistentEntity, this.objectMapper);
        return new SortTranslator(mappedProperties).translateSort(input);
    }

    @ConstructorProperties(value={"objectMapper", "repositories", "domainClassResolver"})
    public JacksonMappingAwareSortTranslator(@NonNull ObjectMapper objectMapper, @NonNull Repositories repositories, @NonNull DomainClassResolver domainClassResolver) {
        if (objectMapper == null) {
            throw new IllegalArgumentException("objectMapper is null");
        }
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        if (domainClassResolver == null) {
            throw new IllegalArgumentException("domainClassResolver is null");
        }
        this.objectMapper = objectMapper;
        this.repositories = repositories;
        this.domainClassResolver = domainClassResolver;
    }

    static class SortTranslator {
        @NonNull
        private final MappedProperties mappedProperties;

        Sort translateSort(Sort input) {
            ArrayList<Sort.Order> filteredOrders = new ArrayList<Sort.Order>();
            for (Sort.Order order : input) {
                if (!this.mappedProperties.hasPersistentPropertyForField(order.getProperty())) continue;
                PersistentProperty<?> persistentProperty = this.mappedProperties.getPersistentProperty(order.getProperty());
                Sort.Order mappedOrder = new Sort.Order(order.getDirection(), persistentProperty.getName(), order.getNullHandling());
                filteredOrders.add(order.isIgnoreCase() ? mappedOrder.ignoreCase() : mappedOrder);
            }
            return filteredOrders.isEmpty() ? null : new Sort(filteredOrders);
        }

        @ConstructorProperties(value={"mappedProperties"})
        public SortTranslator(@NonNull MappedProperties mappedProperties) {
            if (mappedProperties == null) {
                throw new IllegalArgumentException("mappedProperties is null");
            }
            this.mappedProperties = mappedProperties;
        }
    }
}

