/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.RelProvider;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class ControllerRelProvider
implements RelProvider {
    private final Class<?> controllerType;
    private final Class<?> entityType;
    private final PluginRegistry<RelProvider, Class<?>> providers;

    public ControllerRelProvider(Class<?> controller, PluginRegistry<RelProvider, Class<?>> providers) {
        Assert.notNull(controller);
        ExposesResourceFor annotation = (ExposesResourceFor)AnnotationUtils.findAnnotation(controller, ExposesResourceFor.class);
        Assert.notNull((Object)annotation);
        this.controllerType = controller;
        this.entityType = annotation.value();
        this.providers = providers;
    }

    @Override
    public String getCollectionResourceRelFor(Class<?> resource) {
        return ((RelProvider)this.providers.getPluginFor(this.entityType)).getCollectionResourceRelFor(resource);
    }

    @Override
    public String getItemResourceRelFor(Class<?> resource) {
        return ((RelProvider)this.providers.getPluginFor(this.entityType)).getItemResourceRelFor(resource);
    }

    public boolean supports(Class<?> delimiter) {
        return this.controllerType.equals(delimiter);
    }
}

