/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.http;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpMessageHandlerSpec
extends MessageHandlerSpec<HttpMessageHandlerSpec, HttpRequestExecutingMessageHandler>
implements ComponentsRegistration {
    private final RestTemplate restTemplate;
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private boolean headerMapperExplicitlySet;

    HttpMessageHandlerSpec(URI uri, RestTemplate restTemplate) {
        this((Expression)new ValueExpression((Object)uri), restTemplate);
    }

    HttpMessageHandlerSpec(String uri, RestTemplate restTemplate) {
        this((Expression)new LiteralExpression(uri), restTemplate);
    }

    HttpMessageHandlerSpec(Expression uriExpression, RestTemplate restTemplate) {
        this.target = new HttpRequestExecutingMessageHandler(uriExpression, restTemplate);
        ((HttpRequestExecutingMessageHandler)this.target).setHeaderMapper(this.headerMapper);
        this.restTemplate = restTemplate;
    }

    HttpMessageHandlerSpec expectReply(boolean expectReply) {
        ((HttpRequestExecutingMessageHandler)this.target).setExpectReply(expectReply);
        return this;
    }

    public HttpMessageHandlerSpec encodeUri(boolean encodeUri) {
        ((HttpRequestExecutingMessageHandler)this.target).setEncodeUri(encodeUri);
        return this;
    }

    public HttpMessageHandlerSpec httpMethodExpression(Expression httpMethodExpression) {
        ((HttpRequestExecutingMessageHandler)this.target).setHttpMethodExpression(httpMethodExpression);
        return this;
    }

    public <P> HttpMessageHandlerSpec httpMethodFunction(Function<Message<P>, ?> httpMethodFunction) {
        return this.httpMethodExpression(new FunctionExpression<Message<P>>(httpMethodFunction));
    }

    public HttpMessageHandlerSpec httpMethod(HttpMethod httpMethod) {
        ((HttpRequestExecutingMessageHandler)this.target).setHttpMethod(httpMethod);
        return this;
    }

    public HttpMessageHandlerSpec extractPayload(boolean extractPayload) {
        ((HttpRequestExecutingMessageHandler)this.target).setExtractPayload(extractPayload);
        return this;
    }

    public HttpMessageHandlerSpec charset(String charset) {
        ((HttpRequestExecutingMessageHandler)this.target).setCharset(charset);
        return this;
    }

    public HttpMessageHandlerSpec expectedResponseType(Class<?> expectedResponseType) {
        ((HttpRequestExecutingMessageHandler)this.target).setExpectedResponseType(expectedResponseType);
        return this;
    }

    public HttpMessageHandlerSpec expectedResponseType(ParameterizedTypeReference<?> expectedResponseType) {
        return this.expectedResponseTypeExpression((Expression)new ValueExpression(expectedResponseType));
    }

    public HttpMessageHandlerSpec expectedResponseTypeExpression(Expression expectedResponseTypeExpression) {
        ((HttpRequestExecutingMessageHandler)this.target).setExpectedResponseTypeExpression(expectedResponseTypeExpression);
        return this;
    }

    public <P> HttpMessageHandlerSpec expectedResponseTypeFunction(Function<Message<P>, ?> expectedResponseTypeFunction) {
        return this.expectedResponseTypeExpression(new FunctionExpression<Message<P>>(expectedResponseTypeFunction));
    }

    public HttpMessageHandlerSpec errorHandler(ResponseErrorHandler errorHandler) {
        Assert.isNull((Object)this.restTemplate, (String)("the 'errorHandler' must be specified on the provided 'restTemplate': " + this.restTemplate));
        ((HttpRequestExecutingMessageHandler)this.target).setErrorHandler(errorHandler);
        return this;
    }

    public HttpMessageHandlerSpec messageConverters(HttpMessageConverter<?> ... messageConverters) {
        Assert.isNull((Object)this.restTemplate, (String)("the 'messageConverters' must be specified on the provided 'restTemplate': " + this.restTemplate));
        ((HttpRequestExecutingMessageHandler)this.target).setMessageConverters(Arrays.asList(messageConverters));
        return this;
    }

    public HttpMessageHandlerSpec requestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.isNull((Object)this.restTemplate, (String)("the 'requestFactory' must be specified on the provided 'restTemplate': " + this.restTemplate));
        ((HttpRequestExecutingMessageHandler)this.target).setRequestFactory(requestFactory);
        return this;
    }

    public HttpMessageHandlerSpec headerMapper(HeaderMapper<HttpHeaders> headerMapper) {
        this.headerMapper = headerMapper;
        ((HttpRequestExecutingMessageHandler)this.target).setHeaderMapper(this.headerMapper);
        this.headerMapperExplicitlySet = true;
        return this;
    }

    public HttpMessageHandlerSpec mappedRequestHeaders(String ... patterns) {
        Assert.isTrue((!this.headerMapperExplicitlySet ? 1 : 0) != 0, (String)("The 'mappedRequestHeaders' must be specified on the provided 'headerMapper': " + this.headerMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setOutboundHeaderNames(patterns);
        return this;
    }

    public HttpMessageHandlerSpec mappedResponseHeaders(String ... patterns) {
        Assert.isTrue((!this.headerMapperExplicitlySet ? 1 : 0) != 0, (String)("The 'mappedResponseHeaders' must be specified on the provided 'headerMapper': " + this.headerMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setInboundHeaderNames(patterns);
        return this;
    }

    public HttpMessageHandlerSpec uriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        this.uriVariableExpressions.clear();
        this.uriVariableExpressions.putAll(uriVariableExpressions);
        return this;
    }

    public HttpMessageHandlerSpec uriVariable(String variable, Expression expression) {
        this.uriVariableExpressions.put(variable, expression);
        return this;
    }

    public HttpMessageHandlerSpec uriVariable(String variable, String expression) {
        return this.uriVariable(variable, PARSER.parseExpression(expression));
    }

    public <P> HttpMessageHandlerSpec uriVariable(String variable, Function<Message<P>, ?> valueFunction) {
        return this.uriVariable(variable, new FunctionExpression<Message<P>>(valueFunction));
    }

    public HttpMessageHandlerSpec uriVariablesExpression(Expression uriVariablesExpression) {
        ((HttpRequestExecutingMessageHandler)this.target).setUriVariablesExpression(uriVariablesExpression);
        return this;
    }

    public HttpMessageHandlerSpec uriVariablesExpression(String uriVariablesExpression) {
        return this.uriVariablesExpression(PARSER.parseExpression(uriVariablesExpression));
    }

    public <P> HttpMessageHandlerSpec uriVariablesFunction(Function<Message<P>, Map<String, ?>> uriVariablesFunction) {
        return this.uriVariablesExpression(new FunctionExpression<Message<P>>(uriVariablesFunction));
    }

    public HttpMessageHandlerSpec transferCookies(boolean transferCookies) {
        ((HttpRequestExecutingMessageHandler)this.target).setTransferCookies(transferCookies);
        return this;
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        ((HttpRequestExecutingMessageHandler)this.target).setUriVariableExpressions(this.uriVariableExpressions);
        return Collections.singletonList(this.headerMapper);
    }
}

