/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.scripting;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.integration.groovy.GroovyScriptExecutingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.RefreshableResourceScriptSource;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.integration.scripting.jsr223.ScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.jsr223.ScriptExecutorFactory;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.StringUtils;

class DslScriptExecutingMessageProcessor
implements MessageProcessor<Object>,
InitializingBean,
ApplicationContextAware {
    private Resource script;
    private String location;
    private String lang;
    private long refreshCheckDelay = -1L;
    private ScriptVariableGenerator variableGenerator;
    private ApplicationContext applicationContext;
    private AbstractScriptExecutingMessageProcessor<?> delegate;

    DslScriptExecutingMessageProcessor(Resource script) {
        this.script = script;
    }

    DslScriptExecutingMessageProcessor(String location) {
        this.location = location;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setRefreshCheckDelay(Long refreshCheckDelay) {
        this.refreshCheckDelay = refreshCheckDelay;
    }

    public void setVariableGenerator(ScriptVariableGenerator variableGenerator) {
        this.variableGenerator = variableGenerator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.location)) {
            this.script = this.applicationContext.getResource(this.location);
        }
        RefreshableResourceScriptSource scriptSource = new RefreshableResourceScriptSource(this.script, this.refreshCheckDelay);
        if (!StringUtils.hasText((String)this.lang)) {
            String filename = this.script.getFilename();
            int index = filename.lastIndexOf(".") + 1;
            if (index < 1) {
                throw new BeanCreationException("'lang' isn't provided and there is 'file extension' for script resource: " + this.script);
            }
            this.lang = filename.substring(index);
        }
        this.delegate = "groovy".equals(this.lang.toLowerCase()) ? new GroovyScriptExecutingMessageProcessor((ScriptSource)scriptSource, this.variableGenerator) : new ScriptExecutingMessageProcessor((ScriptSource)scriptSource, this.variableGenerator, ScriptExecutorFactory.getScriptExecutor((String)this.lang));
        this.delegate.setBeanFactory((BeanFactory)this.applicationContext);
        this.delegate.setBeanClassLoader(this.applicationContext.getClassLoader());
    }

    public Object processMessage(Message<?> message) {
        return this.delegate.processMessage(message);
    }
}

