/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast.config.annotation.web.http;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.MapListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.ExpiringSession;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.hazelcast.SessionEntryListener;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class HazelcastHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String sessionMapName = "spring:session:sessions";
    private String sessionListenerUid;
    private IMap<String, ExpiringSession> sessionsMap;

    @Bean
    public SessionRepository<ExpiringSession> sessionRepository(HazelcastInstance hazelcastInstance, SessionEntryListener sessionListener) {
        this.sessionsMap = hazelcastInstance.getMap(this.sessionMapName);
        this.sessionListenerUid = this.sessionsMap.addEntryListener((MapListener)sessionListener, true);
        MapSessionRepository sessionRepository = new MapSessionRepository(new ExpiringSessionMap(this.sessionsMap));
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        return sessionRepository;
    }

    @PreDestroy
    private void removeSessionListener() {
        this.sessionsMap.removeEntryListener(this.sessionListenerUid);
    }

    @Bean
    public SessionEntryListener sessionListener(ApplicationEventPublisher eventPublisher) {
        return new SessionEntryListener(eventPublisher);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableHazelcastHttpSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        this.transferAnnotationAttributes(enableAttrs);
    }

    private void transferAnnotationAttributes(AnnotationAttributes enableAttrs) {
        this.setMaxInactiveIntervalInSeconds((Integer)enableAttrs.getNumber("maxInactiveIntervalInSeconds"));
        this.setSessionMapName(enableAttrs.getString("sessionMapName"));
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExpiringSessionMap
    implements Map<String, ExpiringSession> {
        private IMap<String, ExpiringSession> delegate;

        ExpiringSessionMap(IMap<String, ExpiringSession> delegate) {
            this.delegate = delegate;
        }

        @Override
        public ExpiringSession put(String key, ExpiringSession value) {
            if (value == null) {
                return (ExpiringSession)this.delegate.put((Object)key, (Object)value);
            }
            return (ExpiringSession)this.delegate.put((Object)key, (Object)value, (long)value.getMaxInactiveIntervalInSeconds(), TimeUnit.SECONDS);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public ExpiringSession get(Object key) {
            return (ExpiringSession)this.delegate.get(key);
        }

        @Override
        public ExpiringSession remove(Object key) {
            return (ExpiringSession)this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends ExpiringSession> m) {
            this.delegate.putAll(m);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<ExpiringSession> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, ExpiringSession>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

