/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;

public class DatabaseStartupValidator
implements InitializingBean {
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMEOUT = 60;
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private DataSource dataSource;
    @Nullable
    private String validationQuery;
    private int interval = 1;
    private int timeout = 60;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        DataSource dataSource = this.dataSource;
        if (dataSource == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
        if (this.validationQuery == null) {
            throw new IllegalArgumentException("Property 'validationQuery' is required");
        }
        try {
            boolean validated = false;
            long beginTime = System.currentTimeMillis();
            long deadLine = beginTime + TimeUnit.SECONDS.toMillis(this.timeout);
            SQLException latestEx = null;
            while (!validated && System.currentTimeMillis() < deadLine) {
                Connection con = null;
                Statement stmt = null;
                try {
                    con = dataSource.getConnection();
                    if (con == null) {
                        throw new CannotGetJdbcConnectionException("Failed to execute validation query: DataSource returned null from getConnection(): " + dataSource);
                    }
                    stmt = con.createStatement();
                    stmt.execute(this.validationQuery);
                    validated = true;
                }
                catch (SQLException ex) {
                    block13: {
                        try {
                            float rest;
                            latestEx = ex;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Validation query [" + this.validationQuery + "] threw exception"), (Throwable)ex);
                            }
                            if (!this.logger.isWarnEnabled() || !((rest = (float)(deadLine - System.currentTimeMillis()) / 1000.0f) > (float)this.interval)) break block13;
                            this.logger.info((Object)("Database has not started up yet - retrying in " + this.interval + " seconds (timeout in " + rest + " seconds)"));
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeStatement(stmt);
                            JdbcUtils.closeConnection(con);
                            throw throwable;
                        }
                    }
                    JdbcUtils.closeStatement(stmt);
                    JdbcUtils.closeConnection(con);
                }
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection(con);
                if (validated) continue;
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.interval));
            }
            if (!validated) {
                throw new CannotGetJdbcConnectionException("Database has not started up within " + this.timeout + " seconds", latestEx);
            }
            if (this.logger.isInfoEnabled()) {
                float duration = (float)(System.currentTimeMillis() - beginTime) / 1000.0f;
                this.logger.info((Object)("Database startup detected after " + duration + " seconds"));
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

