/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.time.Duration;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.test.web.reactive.server.ExchangeResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FluxExchangeResult<T>
extends ExchangeResult {
    private static final IllegalStateException TIMEOUT_ERROR = new IllegalStateException("Response timeout: for infinite streams use getResponseBody() first with explicit cancellation, e.g. via take(n).");
    private final Flux<T> body;
    private final Duration timeout;

    FluxExchangeResult(ExchangeResult result, Flux<T> body, Duration timeout) {
        super(result);
        this.body = body;
        this.timeout = timeout;
    }

    public Flux<T> getResponseBody() {
        return this.body;
    }

    @Override
    @Nullable
    public byte[] getResponseBodyContent() {
        return (byte[])this.body.ignoreElements().timeout(this.timeout, Mono.error((Throwable)TIMEOUT_ERROR)).then(Mono.defer(() -> Mono.justOrEmpty((Object)super.getResponseBodyContent()))).block();
    }

    public void consumeWith(Consumer<FluxExchangeResult<T>> consumer) {
        this.assertWithDiagnostics(() -> consumer.accept(this));
    }
}

