/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.FileChangeListener;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;

public class ReloadableFileChangeListener
implements FileChangeListener {
    private static Logger log = Logger.getLogger(ReloadableFileChangeListener.class.getName());
    private TypeRegistry typeRegistry;
    private Map<File, ReloadableType> correspondingReloadableTypes = new HashMap<File, ReloadableType>();

    public ReloadableFileChangeListener(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void fileChanged(File file) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info(" processing change for " + file);
        }
        ReloadableType rtype = this.correspondingReloadableTypes.get(file);
        this.typeRegistry.loadNewVersion(rtype, file);
    }

    public void register(ReloadableType rtype, File file) {
        this.correspondingReloadableTypes.put(file, rtype);
    }
}

