/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathException;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class JaxenXPathExpressionFactory {
    JaxenXPathExpressionFactory() {
    }

    static XPathExpression createXPathExpression(String expression) {
        try {
            DOMXPath xpath = new DOMXPath(expression);
            return new JaxenXpathExpression((XPath)xpath);
        }
        catch (JaxenException ex) {
            throw new XPathParseException("Could not compile [" + expression + "] to a XPathExpression: " + ex.getMessage(), ex);
        }
    }

    public static XPathExpression createXPathExpression(String expression, Map<String, String> namespaces) {
        try {
            DOMXPath xpath = new DOMXPath(expression);
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
            return new JaxenXpathExpression((XPath)xpath);
        }
        catch (JaxenException ex) {
            throw new XPathParseException("Could not compile [" + expression + "] to a XPathExpression: " + ex.getMessage(), ex);
        }
    }

    private static class JaxenXpathExpression
    implements XPathExpression {
        private XPath xpath;

        private JaxenXpathExpression(XPath xpath) {
            this.xpath = xpath;
        }

        @Override
        public Node evaluateAsNode(Node node) {
            try {
                return (Node)this.xpath.selectSingleNode((Object)node);
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }

        @Override
        public boolean evaluateAsBoolean(Node node) {
            try {
                return this.xpath.booleanValueOf((Object)node);
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }

        @Override
        public double evaluateAsNumber(Node node) {
            try {
                return this.xpath.numberValueOf((Object)node).doubleValue();
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }

        @Override
        public String evaluateAsString(Node node) {
            try {
                return this.xpath.stringValueOf((Object)node);
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }

        @Override
        public List<Node> evaluateAsNodeList(Node node) {
            try {
                return this.xpath.selectNodes((Object)node);
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }

        @Override
        public <T> T evaluateAsObject(Node context, NodeMapper<T> nodeMapper) throws XPathException {
            try {
                Node result = (Node)this.xpath.selectSingleNode((Object)context);
                if (result != null) {
                    try {
                        return nodeMapper.mapNode(result, 0);
                    }
                    catch (DOMException ex) {
                        throw new XPathException("Mapping resulted in DOMException", ex);
                    }
                }
                return null;
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }

        @Override
        public <T> List<T> evaluate(Node context, NodeMapper<T> nodeMapper) throws XPathException {
            try {
                List nodes = this.xpath.selectNodes((Object)context);
                ArrayList<T> results = new ArrayList<T>(nodes.size());
                for (int i = 0; i < nodes.size(); ++i) {
                    Node node = (Node)nodes.get(i);
                    try {
                        results.add(nodeMapper.mapNode(node, i));
                        continue;
                    }
                    catch (DOMException ex) {
                        throw new XPathException("Mapping resulted in DOMException", ex);
                    }
                }
                return results;
            }
            catch (JaxenException ex) {
                throw new XPathException("Could not evaluate XPath expression [" + this.xpath + "] :" + ex.getMessage(), ex);
            }
        }
    }
}

