/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springside.modules.nosql.redis.JedisTemplate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.util.Pool;

public class JedisScriptExecutor {
    private static Logger logger = LoggerFactory.getLogger(JedisScriptExecutor.class);
    private JedisTemplate jedisTemplate;
    private String script;
    private String sha1;

    public JedisScriptExecutor(Pool<Jedis> jedisPool) {
        this.jedisTemplate = new JedisTemplate(jedisPool);
    }

    public JedisScriptExecutor(JedisTemplate jedisTemplate) {
        this.jedisTemplate = jedisTemplate;
    }

    public void load(final String scriptContent) throws JedisDataException {
        this.sha1 = this.jedisTemplate.execute(new JedisTemplate.JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.scriptLoad(scriptContent);
            }
        });
        this.script = scriptContent;
        logger.debug("Script \"{}\" had been loaded as {}", (Object)scriptContent, (Object)this.sha1);
    }

    public void loadFromFile(String scriptPath) throws JedisDataException {
        String scriptContent;
        try {
            Resource resource = new DefaultResourceLoader().getResource(scriptPath);
            scriptContent = FileUtils.readFileToString((File)resource.getFile());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(scriptPath + " is not exist.", e);
        }
        this.load(scriptContent);
    }

    public Object execute(String[] keys, String[] args) throws IllegalArgumentException {
        Validate.notNull((Object)keys, (String)"keys can't be null.", (Object[])new Object[0]);
        Validate.notNull((Object)args, (String)"args can't be null.", (Object[])new Object[0]);
        return this.execute(Arrays.asList(keys), Arrays.asList(args));
    }

    public Object execute(final List<String> keys, final List<String> args) throws IllegalArgumentException {
        Validate.notNull(keys, (String)"keys can't be null.", (Object[])new Object[0]);
        Validate.notNull(args, (String)"args can't be null.", (Object[])new Object[0]);
        return this.jedisTemplate.execute(new JedisTemplate.JedisAction<Object>(){

            @Override
            public Object action(Jedis jedis) {
                try {
                    return jedis.evalsha(JedisScriptExecutor.this.sha1, keys, args);
                }
                catch (JedisDataException e) {
                    logger.warn("Script {} is not loaded in server yet or the script is wrong, try to reload and run it again.", (Object)JedisScriptExecutor.this.script, (Object)e);
                    return jedis.eval(JedisScriptExecutor.this.script, keys, args);
                }
            }
        });
    }
}

