/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class JedisTemplate {
    private static Logger logger = LoggerFactory.getLogger(JedisTemplate.class);
    private Pool<Jedis> jedisPool;

    public JedisTemplate(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            T t = jedisAction.action(jedis);
            return t;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection lost.", (Throwable)e);
            broken = true;
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            jedisAction.action(jedis);
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection lost.", (Throwable)e);
            broken = true;
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    protected void closeResource(Jedis jedis, boolean connectionBroken) {
        if (jedis != null) {
            try {
                if (connectionBroken) {
                    this.jedisPool.returnBrokenResource((Object)jedis);
                } else {
                    this.jedisPool.returnResource((Object)jedis);
                }
            }
            catch (Exception e) {
                logger.error("Error happen when return jedis to pool, try to close it directly.", (Throwable)e);
                JedisUtils.closeJedis(jedis);
            }
        }
    }

    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }

    public Boolean del(final String ... keys) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.del(keys) == 1L;
            }
        });
    }

    public void flushDB() {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.flushDB();
            }
        });
    }

    public String get(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    public Long getAsLong(String key) {
        String result = this.get(key);
        return result != null ? Long.valueOf(result) : null;
    }

    public Integer getAsInt(String key) {
        String result = this.get(key);
        return result != null ? Integer.valueOf(result) : null;
    }

    public void set(final String key, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.set(key, value);
            }
        });
    }

    public void setex(final String key, final String value, final int seconds) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.setex(key, seconds, value);
            }
        });
    }

    public Boolean setnx(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.setnx(key, value) == 1L;
            }
        });
    }

    public Boolean setnxex(final String key, final String value, final int seconds) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String result = jedis.set(key, value, "NX", "EX", seconds);
                return JedisUtils.isStatusOk(result);
            }
        });
    }

    public Long incr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incr(key);
            }
        });
    }

    public Long decr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.decr(key);
            }
        });
    }

    public void lpush(final String key, final String ... values) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.lpush(key, values);
            }
        });
    }

    public String rpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.rpop(key);
            }
        });
    }

    public Long llen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.llen(key);
            }
        });
    }

    public Boolean lremOne(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long count = jedis.lrem(key, 1L, value);
                return count == 1L;
            }
        });
    }

    public Boolean lremAll(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long count = jedis.lrem(key, 0L, value);
                return count > 0L;
            }
        });
    }

    public Boolean zadd(final String key, final String member, final double score) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.zadd(key, score, member) == 1L;
            }
        });
    }

    public Boolean zrem(final String key, final String member) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.zrem(key, new String[]{member}) == 1L;
            }
        });
    }

    public Double zscore(final String key, final String member) {
        return this.execute(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.zscore(key, member);
            }
        });
    }

    public Long zcard(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zcard(key);
            }
        });
    }

    public static interface JedisActionNoResult {
        public void action(Jedis var1);
    }

    public static interface JedisAction<T> {
        public T action(Jedis var1);
    }
}

