/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

public class JedisUtils {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_TIMEOUT = 2000;
    private static final String OK_CODE = "OK";
    private static final String OK_MULTI_CODE = "+OK";

    public static JedisPoolConfig createPoolConfig(int maxIdle, int maxTotal) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setTimeBetweenEvictionRunsMillis(-1L);
        return poolConfig;
    }

    public static JedisPoolConfig createPoolConfig(int maxIdle, int maxTotal, int checkingIntervalSecs, int evictableIdleTimeSecs) {
        JedisPoolConfig poolConfig = JedisUtils.createPoolConfig(maxIdle, maxTotal);
        poolConfig.setTimeBetweenEvictionRunsMillis((long)(checkingIntervalSecs * 1000));
        poolConfig.setMinEvictableIdleTimeMillis((long)(evictableIdleTimeSecs * 1000));
        return poolConfig;
    }

    public static boolean isStatusOk(String status) {
        return status != null && (OK_CODE.equals(status) || OK_MULTI_CODE.equals(status));
    }

    public static void closeJedis(Jedis jedis) {
        if (jedis != null && jedis.isConnected()) {
            try {
                try {
                    jedis.quit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                jedis.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

