/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis.pool;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisUtils;
import org.springside.modules.nosql.redis.pool.ConnectionInfo;
import org.springside.modules.nosql.redis.pool.JedisFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class JedisSentinelPool
extends Pool<Jedis> {
    private static final String UNAVAILABLE_MASTER_ADDRESS = "All sentinel down";
    private static Logger logger = LoggerFactory.getLogger(JedisSentinelPool.class);
    private String masterName;
    private ConnectionInfo[] sentinelInfos;
    private ConnectionInfo masterAddtionalInfo;
    private JedisPoolConfig masterPoolConfig;
    private MasterSwitchListener masterSwitchListener;

    public JedisSentinelPool(ConnectionInfo sentinelInfo, String masterName, ConnectionInfo masterAddtionalInfo, JedisPoolConfig masterPoolConfig) {
        this(new ConnectionInfo[]{sentinelInfo}, masterName, masterAddtionalInfo, masterPoolConfig);
    }

    public JedisSentinelPool(ConnectionInfo[] sentinelInfos, String masterName, ConnectionInfo masterAddtionalInfo, JedisPoolConfig masterPoolConfig) {
        JedisSentinelPool.assertArgument(sentinelInfos != null && sentinelInfos.length != 0, "seintinelInfos is not set");
        this.sentinelInfos = sentinelInfos;
        JedisSentinelPool.assertArgument(masterAddtionalInfo != null, "masterAddtionalInfo is not set");
        this.masterAddtionalInfo = masterAddtionalInfo;
        JedisSentinelPool.assertArgument(masterName != null && !masterName.isEmpty(), "masterName is not set");
        this.masterName = masterName;
        JedisSentinelPool.assertArgument(masterPoolConfig != null, "masterPoolConfig is not set");
        this.masterPoolConfig = masterPoolConfig;
        this.masterSwitchListener = new MasterSwitchListener();
        this.masterSwitchListener.start();
    }

    public void destroy() {
        this.masterSwitchListener.shutdown();
        this.destroyInternalPool();
        try {
            logger.info("Waiting for MasterSwitchListener thread finish");
            this.masterSwitchListener.join();
            logger.info("MasterSwitchListener thread finished");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void returnResource(Jedis resource) {
        resource.resetState();
        this.returnResourceObject(resource);
    }

    private void initInternalPool(ConnectionInfo masterConnectionInfo) {
        JedisFactory factory = new JedisFactory(masterConnectionInfo.getHost(), masterConnectionInfo.getPort(), masterConnectionInfo.getTimeout(), masterConnectionInfo.getPassword(), masterConnectionInfo.getDatabase(), masterConnectionInfo.getClientName());
        this.internalPool = new GenericObjectPool((PooledObjectFactory)factory, (GenericObjectPoolConfig)this.masterPoolConfig);
    }

    private void destroyInternalPool() {
        super.destroy();
    }

    private static void assertArgument(boolean expression, String message) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    MasterSwitchListener getMasterSwitchListener() {
        return this.masterSwitchListener;
    }

    class MasterSwitchListener
    extends Thread {
        public static final String THREAD_NAME_PREFIX = "RedisMasterSwitchListener-";
        public static final int RETRY_WAIT_TIME_MILLS = 1000;
        private ConnectionInfo sentinelInfo;
        private Jedis sentinelJedis;
        private JedisPubSub subscriber;
        private AtomicBoolean running;
        private ConnectionInfo previousMasterConnectionInfo;

        public MasterSwitchListener() {
            super(THREAD_NAME_PREFIX + JedisSentinelPool.this.masterName);
            this.running = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            while (this.running.get()) {
                try {
                    ConnectionInfo masterConnectionInfo;
                    boolean avalibleSentinelExist = this.selectSentinel();
                    if (avalibleSentinelExist) {
                        try {
                            masterConnectionInfo = this.queryMasterAddress();
                            if (JedisSentinelPool.this.internalPool != null && this.isMasterAddressChanged(masterConnectionInfo)) {
                                logger.info("The internalPool {} had changed, destroy it now.", (Object)this.previousMasterConnectionInfo.getHostAndPort());
                                JedisSentinelPool.this.destroyInternalPool();
                            }
                            if (JedisSentinelPool.this.internalPool == null || this.isMasterAddressChanged(masterConnectionInfo)) {
                                logger.info("The internalPool {} is not init or the address had changed, init it now.", (Object)masterConnectionInfo.getHostAndPort());
                                JedisSentinelPool.this.initInternalPool(masterConnectionInfo);
                            }
                            this.previousMasterConnectionInfo = masterConnectionInfo;
                            this.subscriber = new MasterSwitchSubscriber();
                            this.sentinelJedis.subscribe(this.subscriber, new String[]{"+switch-master", "+redirect-to-master"});
                        }
                        catch (JedisConnectionException e) {
                            JedisUtils.closeJedis(this.sentinelJedis);
                            if (!this.running.get()) continue;
                            logger.error("Lost connection with Sentinel " + this.sentinelInfo.getHostAndPort() + ", sleep 1000ms and try to connect another one.");
                            this.sleep(1000);
                        }
                        catch (Exception e) {
                            JedisUtils.closeJedis(this.sentinelJedis);
                            if (!this.running.get()) continue;
                            logger.error("Unexpected Exception happen, current Sentinel is" + this.sentinelInfo.getHostAndPort() + ", sleep 1000ms and try again.", (Throwable)e);
                            this.sleep(1000);
                        }
                        continue;
                    }
                    logger.info("All sentinels down, sleep 1000ms and try to select again.");
                    if (JedisSentinelPool.this.internalPool == null) {
                        masterConnectionInfo = new ConnectionInfo(JedisSentinelPool.UNAVAILABLE_MASTER_ADDRESS);
                        JedisSentinelPool.this.initInternalPool(masterConnectionInfo);
                        this.previousMasterConnectionInfo = masterConnectionInfo;
                    }
                    this.sleep(1000);
                }
                catch (Exception e) {
                    logger.error("Unexpected exception happen", (Throwable)e);
                    this.sleep(1000);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            this.running.getAndSet(false);
            this.interrupt();
            try {
                if (this.subscriber != null) {
                    this.subscriber.unsubscribe();
                }
            }
            finally {
                JedisUtils.closeJedis(this.sentinelJedis);
            }
        }

        private boolean selectSentinel() {
            for (ConnectionInfo info : JedisSentinelPool.this.sentinelInfos) {
                if (!this.ping(info)) continue;
                this.sentinelInfo = info;
                this.sentinelJedis = new Jedis(this.sentinelInfo.getHost(), this.sentinelInfo.getPort());
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean ping(ConnectionInfo connectionInfo) {
            Jedis jedis = new Jedis(connectionInfo.getHost(), connectionInfo.getPort());
            try {
                String result = jedis.ping();
                boolean bl = result != null && result.equals("PONG");
                return bl;
            }
            catch (JedisException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                JedisUtils.closeJedis(jedis);
            }
        }

        private ConnectionInfo queryMasterAddress() {
            List address = this.sentinelJedis.sentinelGetMasterAddrByName(JedisSentinelPool.this.masterName);
            if (address == null || address.isEmpty()) {
                throw new IllegalArgumentException("Master name " + JedisSentinelPool.this.masterName + " is not in sentinel.conf");
            }
            return this.buildMasterConnectionInfo((String)address.get(0), (String)address.get(1));
        }

        private ConnectionInfo buildMasterConnectionInfo(String host, String port) {
            return new ConnectionInfo(host, Integer.valueOf(port), JedisSentinelPool.this.masterAddtionalInfo.getTimeout(), JedisSentinelPool.this.masterAddtionalInfo.getPassword(), JedisSentinelPool.this.masterAddtionalInfo.getDatabase(), JedisSentinelPool.this.masterAddtionalInfo.getClientName());
        }

        private boolean isMasterAddressChanged(ConnectionInfo currentMasterConnectionInfo) {
            if (this.previousMasterConnectionInfo == null) {
                return true;
            }
            return !this.previousMasterConnectionInfo.getHostAndPort().equals(currentMasterConnectionInfo.getHostAndPort());
        }

        private void sleep(int millseconds) {
            try {
                Thread.sleep(millseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private class MasterSwitchSubscriber
        extends JedisPubSub {
            private MasterSwitchSubscriber() {
            }

            public void onMessage(String channel, String message) {
                logger.info("Sentinel " + MasterSwitchListener.this.sentinelInfo.getHostAndPort() + " published: " + message);
                String[] switchMasterMsg = message.split(" ");
                if (JedisSentinelPool.this.masterName.equals(switchMasterMsg[0])) {
                    JedisSentinelPool.this.destroyInternalPool();
                    ConnectionInfo masterConnectionInfo = MasterSwitchListener.this.buildMasterConnectionInfo(switchMasterMsg[3], switchMasterMsg[4]);
                    logger.info("Switch master to " + masterConnectionInfo.getHostAndPort());
                    JedisSentinelPool.this.initInternalPool(masterConnectionInfo);
                    MasterSwitchListener.this.previousMasterConnectionInfo = masterConnectionInfo;
                }
            }

            public void onPMessage(String pattern, String channel, String message) {
            }

            public void onSubscribe(String channel, int subscribedChannels) {
            }

            public void onUnsubscribe(String channel, int subscribedChannels) {
            }

            public void onPUnsubscribe(String pattern, int subscribedChannels) {
            }

            public void onPSubscribe(String pattern, int subscribedChannels) {
            }
        }
    }
}

