/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis.scheduler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springside.modules.nosql.redis.JedisScriptExecutor;
import org.springside.modules.nosql.redis.scheduler.Keys;
import org.springside.modules.utils.Threads;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class JobDispatcher
implements Runnable {
    public static final String DEFAULT_DISPATCH_LUA_FILE = "classpath:/redis/dispatch.lua";
    public static final long DEFAULT_INTERVAL_MILLIS = 1000L;
    public static final boolean DEFAULT_RELIABLE = false;
    public static final long DEFAULT_JOB_TIMEOUT_SECONDS = 60L;
    private ScheduledExecutorService internalScheduledThreadPool;
    private ScheduledFuture dispatchJob;
    private long intervalMillis = 1000L;
    private boolean reliable = false;
    private long jobTimeoutSecs = 60L;
    private JedisScriptExecutor scriptExecutor;
    private String scriptPath = "classpath:/redis/dispatch.lua";
    private String jobName;
    private List<String> keys;

    public JobDispatcher(String jobName, Pool<Jedis> jedisPool) {
        this.jobName = jobName;
        String scheduledJobKey = Keys.getScheduledJobKey(jobName);
        String readyJobKey = Keys.getReadyJobKey(jobName);
        String dispatchCounterKey = Keys.getDispatchCounterKey(jobName);
        String lockJobKey = Keys.getLockJobKey(jobName);
        String retryCounterKey = Keys.getRetryCounterKey(jobName);
        this.keys = Lists.newArrayList((Object[])new String[]{scheduledJobKey, readyJobKey, dispatchCounterKey, lockJobKey, retryCounterKey});
        this.scriptExecutor = new JedisScriptExecutor(jedisPool);
    }

    public void start() {
        this.internalScheduledThreadPool = Executors.newScheduledThreadPool(1, Threads.buildJobFactory((String)("Job-Dispatcher-" + this.jobName + "-%d")));
        this.start(this.internalScheduledThreadPool);
    }

    public void start(ScheduledExecutorService scheduledThreadPool) {
        this.scriptExecutor.loadFromFile(this.scriptPath);
        this.dispatchJob = scheduledThreadPool.scheduleAtFixedRate((Runnable)new Threads.WrapExceptionRunnable((Runnable)this), 0L, this.intervalMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.dispatchJob.cancel(false);
        if (this.internalScheduledThreadPool != null) {
            Threads.normalShutdown((ExecutorService)this.internalScheduledThreadPool, (int)5, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        long currTime = System.currentTimeMillis();
        ArrayList args = Lists.newArrayList((Object[])new String[]{String.valueOf(currTime), String.valueOf(this.reliable), String.valueOf(this.jobTimeoutSecs)});
        this.scriptExecutor.execute(this.keys, args);
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public void setIntervalMillis(long intervalMillis) {
        this.intervalMillis = intervalMillis;
    }

    public void setReliable(boolean reliable) {
        this.reliable = reliable;
    }

    public void setJobTimeoutSecs(long jobTimeoutSecs) {
        this.jobTimeoutSecs = jobTimeoutSecs;
    }
}

