/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis.scheduler;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.scheduler.Keys;
import org.springside.modules.utils.Threads;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class SimpleJobConsumer {
    public static final int DEFAULT_POPUP_TIMEOUT_SECONDS = 5;
    public static final int DEFAULT_CONNECTION_RETRY_MILLS = 5000;
    private static Logger logger = LoggerFactory.getLogger(SimpleJobConsumer.class);
    private JedisTemplate jedisTemplate;
    private String readyJobKey;
    private int popupTimeoutSecs = 5;

    public SimpleJobConsumer(String jobName, Pool<Jedis> jedisPool) {
        this.jedisTemplate = new JedisTemplate(jedisPool);
        this.readyJobKey = Keys.getReadyJobKey(jobName);
    }

    public String popupJob() {
        List<String> nameValuePair = null;
        try {
            nameValuePair = this.jedisTemplate.execute(new JedisTemplate.JedisAction<List<String>>(){

                @Override
                public List<String> action(Jedis jedis) {
                    return jedis.brpop(SimpleJobConsumer.this.popupTimeoutSecs, new String[]{SimpleJobConsumer.this.readyJobKey});
                }
            });
        }
        catch (JedisConnectionException e) {
            Threads.sleep((long)5000L);
        }
        if (nameValuePair != null && !nameValuePair.isEmpty()) {
            return nameValuePair.get(1);
        }
        return null;
    }

    public void setPopupTimeoutSecs(int popupTimeoutSecs) {
        this.popupTimeoutSecs = popupTimeoutSecs;
    }
}

