package com.roco.settle.api.entity.enterprisesettle;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/** 业务基点->油卡结算申请
 * @author zhangmin
 * @date 2020/2/29
 */
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
@Table(name = "settle_enterprise_oilcard_apply")
public class SettleEnterpriseOilCardApply implements Serializable {

    @Id
    private Long id;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 业务基点简称
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     * 业务基点资金账户编码
     */
    private String enterpriseCapitalAccountNo;

    /**
     * 是否人保机构  1或0
     */
    private Integer isPicc;

    /**
     * 人保机构编码
     */
    private String piccOrgCode;

    /**
     * 事项名称
     */
    private String itemName;

    /**
     * 事项说明
     */
    private String itemDesc;

    /**
     * 结算金额, 本次申请要结算的结算金额
     */
    private BigDecimal settleAmount;

    /**
     * 服务清单总套餐金额
     */
    private BigDecimal totalPackageAmount;

    /**
     * 服务清单总笔数
     */
    private Integer totalQuantity;

    /**
     * 申请附件地址
     */
    private String applyFileUrl;

    /**
     * 申请附件名
     */
    private String applyFileName;

    /**
     * 状态
     */
    private String status;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String updateUser;

    private String updateName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate updateDate;


    /**
     * 获取创建年份
     * @return
     */
    public Integer getCreateYear() {
        return createTime != null ? createTime.getYear(): null;
    }

    /**
     * 获取创建月份
     * @return
     */
    public Integer getCreateMonth() {
        return createTime != null ? createTime.getMonthValue(): null;
    }

}
