package com.rocogz.syy.activity.dto.reo;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author djt
 * @date 2022/1/11
 */
@Data
@Accessors(chain = true)
public class ReoReceiveRecordSearchReq {

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 领取记录编号
     */
    private String recordCode;

    /**
     * 用户手机号
     */
    private String userPhone;

    /**
     * 投放平台miniAppid
     */
    private List<String> miniAppIds;

    /**
     * 赠送发放主体编码
     */
    private List<String> issuingBodyCodes;

    /**
     * 领取开始时间
     */
    private String receiveStartTime;

    /**
     * 领取结束时间
     */
    private String receiveEndTime;

    /**
     * 当前页
     */
    private int page=1;

    /**
     * 页大小
     */
    private int limit=10;


    public Map<String,Object> toMap(){
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.hasLength(this.recordCode)){
            params.put("recordCode", this.recordCode);
        }
        if (StringUtils.hasLength(this.activityCode)){
            params.put("activityCode", this.activityCode);
        }
        if (StringUtils.hasLength(this.userPhone)){
            params.put("userPhone",this.userPhone);
        }
        if (!CollectionUtils.isEmpty(this.miniAppIds)){
            params.put("miniAppIds",this.miniAppIds);
        }
        if (!CollectionUtils.isEmpty(this.issuingBodyCodes)){
            params.put("issuingBodyCodes",this.issuingBodyCodes);
        }
        if (Objects.nonNull(this.receiveStartTime)){
            params.put("receiveStartTime",this.receiveStartTime);
        }
        if (Objects.nonNull(this.receiveEndTime)){
            params.put("receiveEndTime",this.receiveEndTime);
        }
        return params;
    }
}
