/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.alipay.config;

import com.alipay.easysdk.factory.Factory;
import com.alipay.easysdk.kernel.Config;
import com.rocogz.syy.alipay.config.AlipayProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={AlipayProperties.class})
@ConditionalOnProperty(prefix="alipay", value={"enabled"}, matchIfMissing=true)
public class AlipayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AlipayAutoConfiguration.class);
    @Autowired
    private AlipayProperties properties;

    @PostConstruct
    private void setAlipayConfig() {
        if (StringUtils.isEmpty((Object)this.properties.getAppId())) {
            return;
        }
        log.info("\u521d\u59cb\u5316\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u5f00\u59cb");
        Config config = new Config();
        config.protocol = this.properties.protocol;
        config.gatewayHost = this.properties.gatewayHost;
        config.signType = this.properties.signType;
        config.appId = this.properties.appId;
        config.merchantPrivateKey = this.properties.merchantPrivateKey;
        config.merchantCertPath = this.properties.merchantCertPath;
        config.alipayCertPath = this.properties.alipayCertPath;
        config.alipayRootCertPath = this.properties.alipayRootCertPath;
        config.alipayPublicKey = this.properties.alipayPublicKey;
        config.notifyUrl = this.properties.notifyUrl;
        config.encryptKey = this.properties.encryptKey;
        Factory.setOptions((Config)config);
        log.info("\u521d\u59cb\u5316\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u7ed3\u675f");
    }
}

