package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券撤回、作废请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-04-26 17:17:46</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class UserCouponCancelParamDto {

    /**
     * 来源:车服传入：SYY， 分销传入：SCM
     */
    @NotNull(message = "来源" + EquityConstants.EMPTY_MESSAGE)
    private String source;

    /**
     * 清单编号（业务单号）
     */
    @NotNull(message = "业务单号" + EquityConstants.EMPTY_MESSAGE)
    private String applyDetailCode;

    /**
     * 用户券编号列表
     */
    private List<String> codeList;

    /**
     * 操作人
     */
    @NotNull(message = "操作人" + EquityConstants.EMPTY_MESSAGE)
    private String operateUser;
}
