package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券发放 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-05-11 17:18:29</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserCouponDto {

    /**
     * 优惠券编号
     */
    @NotNull(message = "优惠券编号" + EquityConstants.EMPTY_MESSAGE)
    private String couponCode;

    /**
     * 发放平台
     */
    @NotNull(message = "发放平台" + EquityConstants.EMPTY_MESSAGE)
    private String grantPlatformCode;

    /**
     * 发放主体
     */
    @NotNull(message = "发放主体" + EquityConstants.EMPTY_MESSAGE)
    private String source;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 可用平台
     */
    @NotNull(message = "可用平台" + EquityConstants.EMPTY_MESSAGE)
    private String availablePlatformCode;

    /**
     * 可用次数
     */
    @NotNull(message = "可用次数" + EquityConstants.EMPTY_MESSAGE)
    private Integer totalQuantity;

    /**
     * 展示标志:Y-是（用户手机端可见此券），N-否（用户手机端不可见此券）
     */
    @NotNull(message = "展示标志" + EquityConstants.EMPTY_MESSAGE)
    private String showFlag;

    /**
     * 发放方式：RECEIVE-会员领取，
     */
    @NotNull(message = "发放方式" + EquityConstants.EMPTY_MESSAGE)
    private String grantModel;

    /**
     * 生效日期:yyyy-MM-dd 00:00:00
     */
    private LocalDateTime effectiveDate;

    /**
     * 失效日期:yyyy-MM-dd 23:59:59
     */
    private LocalDateTime invalidDate;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * openId
     */
    private String openId;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;

    /**
     * 第三方编码
     * @description Andy 2020-07-02 11:11:05
     */
    private String thirdCode;

    /**
     * 第三方金额
     * @description Andy 2020-07-02 11:11:05
     */
    private BigDecimal thirdAmount;

    /**
     * 是否领取验证：Y-是，N-否
     */
    private String isReceiveVerify;

    /**
     * 是否需要领取: Y-需要，N-不需要
     */
    private String isReceive;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL:正常发券
     */
    private String nature;

    /**
     * 操作用户
     */
    private String createUser;
}
