package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 申请单发短信记录表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-02-18 18:14:00</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_send_message_record")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionSendMessageRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 平台
     */
    private String miniAppid;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发送类型：NORMAL：正常通知，OUT：外呼通知，BATCH：批量通知
     */
    private String sendType;

    /**
     * 发送类型：NOW:即时发送，QUARTZ:定时发送
     */
    private String type;

    /**
     * 参数
     */
    private String param;

    /**
     * 时段：AM：上午，PM：下午，NIGHT:晚上
     */
    private String timeRegion;

    /**
     * 发送次数
     */
    private Integer sendQuantity;

    /**
     * 领取状态：Y-已领取，N-未领取
     */
    private String receiveStatus;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 操作人 
     */
    private String createUser;

    /**
     * 发送时间
     */
    private LocalDateTime createTime;

}
