package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * B端礼赠申请单金额信息
 * </p>
 *
 * @author zhangmin
 * @since 2021-05-21
 */
@Setter @Getter
@Accessors(chain = true)
public class EquityCouponApplyOrder extends IdEntity {

    /**
     * 申请单编码
     * @see EquityBatchDistributionCouponApply#applyNo
     */
    private String applyNo;

    /**
     * 预算金额[B端送礼专属字段]
     */
    private BigDecimal budgetAmount;

    /**
     * 接受礼品客户手机号[B端送礼专属字段]
     */
    private String customerMobile;

    /**
     * 接受礼品客户姓名[B端送礼专属字段]
     */
    private String customerName;

    /**
     * 接受礼品客户车牌号[B端送礼专属字段]
     */
    private String customerCarLicense;

    /**
     * 申请单总金额[B端送礼专属字段]
     */
    private BigDecimal totalAmount;

    /**
     * 现金金额[B端送礼专属字段]
     */
    private BigDecimal cashAmount;

    /**
     * 抵扣额度[B端送礼专属字段]
     */
    private BigDecimal deductQuota;

    /**
     * 现金,现金+额度，纯额度 [B端送礼专属字段]
     * @see EquityConstants.DictEquityApplyPayMode
     */
    private String payMode;

    /**
     * 额度冻结状态：冻结成功,冻结失败[B端送礼专属字段]
     * @see EquityConstants.DictEquityApplyFrozenStatus
     */
    private String frozenStatus;

    /**
     * 现金支付状态：待支付、已支付[B端送礼专属字段]
     * @see EquityConstants.DictEquityApplyOrderStatus
     */
    private String cashPayStatus;

    /**
     * 整单支付状态：待支付、已支付、已取消[B端送礼专属字段]
     * @see EquityConstants.DictEquityApplyOrderStatus
     */
    private String orderStatus;

    /**
     * 支付完成时间[B端送礼专属字段]
     */
    private LocalDateTime payTime;

    /**
     * 取消时间[B端送礼专属字段]
     */
    private LocalDateTime cancelTime;

}
