package com.rocogz.syy.equity.entity.oilCardUserCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 大诚电子加油券-用户券 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-30 14:25:41</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_user_coupon")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardUserCoupon extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 发放平台
     */
    private String grantPlatformCode;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 名称
     */
    private String name;

    /**
     * 状态（未生效、未使用、已兑换、已过期、已冻结、已作废、已退回）
     */
    private String status;

    /**
     * 是否领取验证：Y-是，N-否
     */
    private String isReceiveVerify;

    /**
     * 领取验证结果：Y-通过，N-不通过
     */
    private String receiveVerifyResult;

    /**
     * 领取验证时间
     */
    private LocalDateTime receiveVerifyTime;

    /**
     * 点击状态：Y-已点击，N-未点击
     */
    private String clickStatus;

    /**
     * 点击时间
     */
    private LocalDateTime clickTime;

    /**
     * 积分账号
     */
    private String pointAccountCode;

    /**
     * 微信openid
     */
    private String openId;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码密文
     */
    private String idCard;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;

    /**
     * 积分发放类型：
     * TEAM_ORDER：团队订单
     * PERSON_ORDER：个人订单
     * NORMAL：普通发放
     */
    @TableField(exist = false)
    private String type;

    /**
     * 产品编码（积分账户类型）
     * ROCO_POINT：大诚积分
     * ROCO_AGENT_POINT：代理商积分
     */
    private String productCode;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 来源用户券编号
     */
    private String sourceUserCouponCode;

    /**
     * 订单编号
     */
    private String oilOrderCode;

    /**
     * 订单金额
     */
    private BigDecimal orderAmount;

    /**
     * 可用金额
     */
    private BigDecimal availableAmount;

    /**
     * 已用金额
     */
    private BigDecimal useAmount;

    /**
     *  发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 领取标志：Y-已领取，N-未领取
     */
    private String receiveFlag;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 机构号
     * @description Andy 2020-07-22 15:24:25
     */
    private String orgCode;

    /**
     * 发放主体
     * @description Andy 2020-07-22 15:24:25
     */
    private String sourceCode;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 备注
     * @description Andy 2020-10-13 17:28:17
     */
    private String rmk;

    /**
     * 回调记录
     */
    @TableField(exist = false)
    private EquityOilCardUserCouponRequestOperateSerial callBackRecord;

}
