package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券使用信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-18 12:59:32</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_use_info")
public class EquityUserCouponUseInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 归属套餐券编号
     */
    private String giftCouponCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 可用平台
     */
    private String platformCode;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 订单失效日期
     */
    private LocalDateTime orderInvalidDate;

    /**
     * 总次数
     */
    private Integer totalQuantity;

    /**
     * 已用次数
     */
    private Integer useQuantity;

    /**
     * 可用次数
     */
    private Integer availableQuantity;

    /**
     * 展示标志：展示、不展示
     */
    private String showFlag;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
