package com.rocogz.syy.equity.dto.equity.recall;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:撤回申请单，从那个申请单引申出来的
 * 主要是用在 创建撤回申请时 回显数据。
 * 原来使用的是 才哥 清单查询列表 的第一条数据。
 * 最后想想还是 分开写
 * </dd>
 * <dd>@date: 2021/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class RecallApplyFromApplyDocDto {

    /**
     * 发放业务号，也就是批量发券的申请单号
     */
    private String applyNo;
    /**
     * 申请单清单编号
     */
    private String applyDetailCode;
    /**
     * 客户手机号
     */
    private String mobile;


    /**
     * 代理商编号（服务商编号）
     */
    private String agentCode;

    /**
     * 代理商名称（服务商名称）
     */
    private String agentName;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 权益类型名称
     */
    private String couponTypeName;

    /**
     * 权益名称
     */
    private String couponName;
    /**
     * 权益类型编号
     */
    private String couponTypeCode;

    /**
     * 发放主体
     */
    private String sourceCode;
    /**
     * 发放主体名称
     */
    private String sourceName;

    /**
     * 团队编号
     */
    private String teamCode;
    /**
     * 团队名称
     */
    private String teamName;

    /**
     * 权益总面值， detail.quantity * detail.unit_face_value
     */
    private BigDecimal totalFaceValue;
    /**
     * 单位面值
     */
    private BigDecimal unitFaceValue;

    /**
     * 发放人 对应的是apply中的CreateUser
     */
    private String grantApplyUser;

    /**
     * 领取平台
     */
    private String miniAppid;

    /**
     * 客户领取平台
     */
    private String miniAppidName;


    /**
     * 发放数量 detail.quantity
     */
    private Integer quantity;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 详情状态：detail.status 发放状态
     */
    private String applyDetailStatus;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 发券性质
     */
    private String nature;
    /**
     * 发券性质名称
     */
    private String natureName;

    /**
     * 领取状态
     */
    private String receiveStatus;

    /**
     * 领取状态名称
     */
    private String receiveStatusName;


}
