package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 发放用户券请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-03-10 16:00:56</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ScmGrantUserCouponParamDto {

    /**
     * 分销系统订单编号（全局唯一）
     */
    @NotNull(message = "明细订单编号" + EquityConstants.EMPTY_MESSAGE)
    private String orderCode;

    /**
     * 套餐明细订单编号
     */
    private String comboOrderItemCode;

    /**
     * 申请单号（业务主单号）
     */
    private String applyNo;

    /**
     * ROCO请求申请单清单编号（业务单号）
     */
    private String applyDetailCode;

    /**
     * 发放平台
     */
    private String grantPlatform;

    /**
     * 发放方式：BATCH-批量发放，INTERFACE-接口发放，MANUAL-手工发放
     */
    private String grantWay;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 操作用户
     */
    private String operateUser;

    /**
     * 操作人手机号
     */
    private String operateUserMobile;

    /**
     * 发放主体
     */
    private String source;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 领取生效日期：yyyy-MM-dd 00:00:00
     */
    private LocalDateTime receiveEffectiveDate;

    /**
     * 领取失效日期：yyyy-MM-dd 23:59:59
     */
    private LocalDateTime receiveInvalidDate;

    /**
     * 使用生效日期:yyyy-MM-dd 00:00:00
     */
    private LocalDateTime effectiveDate;

    /**
     * 使用失效日期:yyyy-MM-dd 23:59:59
     */
    private LocalDateTime invalidDate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 用户号
     */
    private String userCode;

    /**
     * openId
     */
    private String openId;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     *车架号
     */
    private String vinNo;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL:正常发券
     */
    private String nature;

    /**
     * 平台产品编码
     */
    @NotNull(message = "平台产品编码" + EquityConstants.EMPTY_MESSAGE)
    private String productCode;

    /**
     * 套餐平台产品编号
     */
    private String comboProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 发放规则编号
     */
    private String grantRuleCode;

    /**
     * 领取规则编号
     */
    private String receiveRuleCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 是否需要领取:Y-需要，N-不需要
     */
    private String isReceive;

    /**
     * 品牌编号:merchant_goods#brandCode
     */
    private String brand;

}
