package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券投放来源（主体）关系 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:28:22</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_source_rel")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponSourceRel extends IdEntity {

    private static final long serialVersionUID=1L;

    public EquityCouponSourceRel(){}

    public EquityCouponSourceRel(String sourceCode){
        this.sourceCode = sourceCode;
    }

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 投放来源（主体）编号
     */
    private String sourceCode;

    /**
     * 投放主体信息
     */
    @TableField(exist = false)
    private IssuingBody issuingBody;


}
