package com.rocogz.syy.equity.dto.issuingBody;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.issuingBody.EquityIssuingBodyContacts;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 发放主体Dto对象
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-08
 */
@Data
@Accessors(chain = true)
public class IssuingBodyDto extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主体类型(目前分为三种:人保机构 ROCO_ORG, 合作企业 ENTERPRISE, 平台商户 BUSINESS)
     */
    private String type;

    /**
     * 父级主体编码,父级主体编码为0的为顶级主体
     */
    private String pCode;

    /**
     * 父级主体名称
     */
    private String pName;

    /**
     * 父级主体简称
     */
    private String pIssuingBodyAbbreviation;

    /**
     * 主体等级(默认顶级为1级,其子级为2级,以此类推)
     */
    private Integer level;

    /**
     * 主体编码
     */
    private String code;

    /**
     * 主体名称
     */
    private String name;

    /**
     * 关联主体编码 (当主体类型是人保机构时代表机构编码,是合作企业时代表社会信用代码,是平台商户时代表平台商户编码)
     */
    private String linkedBodyCode;

    /**
     * 平台商户名称
     */
    private String businessName;

    /**
     * 关联主体名称 (当主体类型是人保机构时代表机构名称,是合作企业时代表企业名称,是平台商户时此项为空)
     */
    private String linkedBodyName;

    /**
     * 简称(人保机构和合作企业才有)
     */
    private String abbreviation;

    /**
     * 说明(只有合作企业才有)
     */
    private String description;

    /**
     * 状态(分为OPEN/LOCK)
     */
    private String status;

    /**
     * 是否存在下级(分为Y/N)
     */
    private String  existSon;

    /**
     * 类型名称(人保机构, 合作企业, 平台商户)
     */
    private String  typeName;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    private String miniName;

    /**
     * 服务平台名称
     */
    private String servicePlatformName;

    /**
     * 发放主体性质
     */
    private String whetherCustomer;

    /**
     * 合作客户编码
     */
    private String customerCode;

    /**
     * 合作客户简称
     */
    private String customerAbbreviation;

    /**
     * 关联角色id列表
     */
    @TableField(exist = false)
    private List<Integer> roleIdList;

    /**
     * 关联角色列表
     */
    private List<IssuingBodyRoleDto> roleList;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 发放主体联系人列表
     */
    private List<EquityIssuingBodyContacts> issuingBodyContacts;

    /**
     * 电子券显示的赠送方名称
     */
    private String giverName;

    /**
     * 产品发放模式
     */
    private String productDistributionMode;

    /**
     * 卡券领取信息可见性 Y: 可见, N 不可见
     */
    private String couponReceiveVisible;

    /**
     * 发放主体简称
     */
    private String issuingBodyAbbreviation;

    /**
     * 所属代理商
     */
    private String belongAgent;

    /**
     * 所属代理商名称
     */
    @TableField(exist = false)
    private String belongAgentName;

    /**
     * 所属代理商简称
     */
    @TableField(exist = false)
    private String belongAgentAbbreviation;

    /**
     * 企业类型
     */
    private String enterpriseType;

    /**
     * 业务性质分类
     */
    private String businessNatureClassification ;

    /**
     * 结算单位标记
     */
    private String settlementUnitMark;

    /**
     * 存在结算主体(Y:有,N:没有)
     */
    private String existSettleSubject;

    /**
     * 对应结算主体编码列表
     */
    @TableField(exist = false)
    private List<String> settleSubjectCodeList;

    /**
     * 同级顺序号
     */
    private Integer sort;

    /**
     * 所属结算单位
     */
    private String belongSettlementUnit;

    /**
     * 所属结算单位主体
     */
    @TableField(exist = false)
    private IssuingBody belongSettlementUnitBody;

    /**
     * 生效方式
     */
    private String effectiveType;

    /**
     *  领取XX天生效
     */
    private String effectiveDate;

    /**
     * 失效方式
     */
    private String invalidType;

    /**
     *
     领取XX天失效
     */
    private String invalidDate;

    /**
     * 有效期设置时点
     *
     */
    private String settingTimePoint;

    /**
     * 生效方式（IMMEDIATE：立即生效、DELAY：延时生效、DEFINITE：指定日期）
     */
    private String effectiveRuleMode;

    /**
     * 生效方式: 延时生效天数（生效方式为延时生效时有值）
     */
    private Integer effectiveDelayDays;

    /**
     * 失效方式：（CALC_BY_GOOD：取平台产品有效期天数计算、 DELAY：生效xx天后失效、 DEFINITE：指定日期）
     */
    private String invalidRuleMode;

    /**
     * 失效方式: 生效延迟xx天后失效（失效方式为延时生效时有值）
     */
    private Integer invalidDelayDays;

    /**
     * 规则类型(ALL:发放主体的所有产品, SPECIFIC：指定产品)
     *
     */
    private String ruleNature;

    /**
     * 触发调用上游的方式(MANUAL：手动、AUTO:自动)
     *
     */
    private String remoteTriggerMode;

    /**
     * 使用规则id
     */
    private Integer useRuleId;

    /**
     * 领取规则编码
     *
     */
    private String receiveRuleCode;

    /**
     * 唯一识别码
     *
     */
    private String identifyCode;

    /**
     * 小程序发放是否需要审批(Y:需要,N:不需要)
     */
    private String whetherNeedApprove;

    /**
     * 是否有下级主体(Y:有,N:没有)
     */
    private String existChildrenIssuingBody;

    /**
     * 是否有团队(Y:有,N:没有)
     */
    private String exitTeam;

}
