package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description:批量发券审核规则配置的配置触发类型：目前有两种：次数限制，总金额限制 的条件： </dd>
 * 手机号,车牌号,姓名 。
 *
 * <dd>@date: 2021/03/25</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_apply_limit_config_condition")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionApplyLimitConfigCondition extends IdEntity {

    private static final long serialVersionUID=1L;
    /**
     * 注册编号 @see EquityBatchDistributionApplyLimitConfig.code
     */
    private String configCode;
    /**
     * 发放主体编码
     */
    private String sourceCode;
    /**
     * 规则条件编码 MOBILE，NAME，在字典中配置的
     * @see EquityConstants.EquityBatchApplyLimitTypeRuleCondition
     */

    private String conditionRuleCode;


    //传输对象
    //编辑和展示方便
    /**
     * conditionRuleCode的字典名称
     */
    private transient String dictName;

    /**
     * conditionRuleCode的字典描述
     */
    private transient String dictDesc;

    /**
     * conditionRuleCode的字典状态
     */
    private transient String dictStatus;


}
