package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 发券申请原清单,拆单之前清单数据</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:54</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_origin_detail")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyOriginDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 申请单类型,即发放渠道
     * @see EquityConstants.DictEquityApplyType
     */
    private String applyType;

    /**
     * 小程序id
     */
    private String miniAppid;


    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 原清单编号,拆单之前的清单编号
     */
    private String code;

    /**
     * 平台产品编号
     */
    private String platformProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 仓库编码
     */
    private String whCode;

    /**
     * 发放规则编码
     */
    private String grantRuleCode;

    /**
     * 领取规则编码
     */
    private String receiveRuleCode;

    /**
     * 扣减时点：领取时扣减：DEDUCTION_ON_COLLECTION， 发放时扣减：DEDUCTION_ON_ISSUE
     */
    private String dedutionTimePoint;

    /**
     * 触发调用上游的方式：MANUAL-手动、AUTO-自动
     * @2022-03-16 17:42:48 Andy
     */
    private String remoteTriggerMode;

    /**
     * 触发调用上游次数
     * @2022-03-16 17:42:48 Andy
     */
    private Integer remoteTriggerQuantity;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;


    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 续保员
     */
    private String renewalInsurePerson;

    /**
     * 保费及税款合计(原车险保费)
     */
    private BigDecimal carInsurancePremium;

    /**
     * 商业险保费合计
     */
    private BigDecimal businessInsurancePremium;

    /**
     * 年审日期
     */
    private String yearReviewDate;

    /**
     * 保养日期
     */
    private String maintenanceDate;

    /**
     * 业务员
     */
    private String salesman;

    /**
     * 业务来源
     */
    private String businessSource;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 主体发券类型, 页面显示：发券类型
     */
    private String grantCouponType;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 状态：INIT-初始，SUCCESS-成功，FAIL-失败
     */
    private String status;

    /**
     * 是否审核数据：Y-是，N-否
     */
    private String approveFlag;

    /**
     * 发放数量
     */
    private Integer quantity;

    /**
     * 此数据在文件内行数
     */
    private Integer rowNum;

    /**
     * 单个产品的 扣减额度
     *（1）代理商产品的   agentProduct.getPurchasePrice() 结算价
     * (2）合作客户产品的 customerProduct.getSettlePrice() 结算价
     */
    private BigDecimal dedutionAmount;

    /**
     * (1) 单个产品 的单位面值/用户输入的自定义面额(直充值或积分)
     * (2) 单个平台产品市场价
     **/
    private BigDecimal unitFaceValue;

    /**
     * 领取生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 领取失效日期
     */
    private LocalDate invalidDate;

    /**
     * 使用生效日期
     */
    private LocalDate useEffectiveDate;

    /**
     * 使用失效日期
     */
    private LocalDate useInvalidDate;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 描述
     */
    private String description;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放月份
     */
    private String grantMonth;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 领取状态
     */
    private String receiveStatus;

    /**
     * 注释
     */
    private String notes;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建人手机号
     */
    private String createUserMobile;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建年份
     */
    private String createYear;

    /**
     * 分拆的现金[B端送礼专属字段]
     */
    private BigDecimal allocatedCash;

    /**
     * 分拆的额度[B端送礼专属字段]
     */
    private BigDecimal allocatedQuota;


    /**
     * 分拆的备付金额度[B端送礼专属字段]
     */
    private BigDecimal allocatedCoverQuota;

    /**
     * 保险公司
     */
    private String insuranceCompany;

    /**
     * 商业保险费比例
     */
    private BigDecimal businessInsuranceRate;

    /**
     * 投保人
     */
    private String policyHolderPerson;

    /**
     * 被保人
     */
    private String insuredPerson;

    /**
     * 车主
     */
    private String carOwner;

    /**
     * 出单日期
     */
    private LocalDate policyCreateDate;

    /**
     * 交强险保费合计
     */
    private BigDecimal compulsoryInsurancePremium;

    /**
     * 车船税税款合计
     */
    private BigDecimal vehicleVesselTax;

    /**
     * 其他险种保费合计
     */
    private BigDecimal otherInsurancePremium;

    /**
     * 商业险返点点数
     */
    private BigDecimal businessInsuranceRebate;

    /**
     * 交强险返点点数
     */
    private BigDecimal compulsoryInsuranceRebate;

    /**
     * 商业险返点金额
     */
    private BigDecimal businessInsuranceRebateAmount;

    /**
     * 交强险返点金额
     */
    private BigDecimal compulsoryInsuranceRebateAmount;

    /**
     * 返点合计
     */
    private BigDecimal totalRebate;

    /**
     * 到账日期
     */
    private LocalDate dateOfReceipt;
}
