package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * B端礼赠申请单支付信息
 * </p>
 *
 * @author zhangmin
 * @since 2021-05-21
 */
@Setter @Getter
public class EquityCouponApplyPayment extends IdEntity {

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 支付状态：待支付、部分支付、支付完成
     * @see EquityConstants.DictEquityApplyPayStatus
     */
    private String payStatus;

    /**
     * 需支付现金金额
     */
    private BigDecimal payAmt;

    /**
     * 已成功支付现金金额
     */
    private BigDecimal successAmt;

    /**
     * 需支付额度
     */
    private BigDecimal payQuota;

    /**
     * 已成功支付额度
     */
    private BigDecimal successQuota;

    /**
     * 支付描述：如：购买1本书
     */
    private String description;

    /**
     * 支付完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 支付单创建人
     */
    private String createUser;

    /**
     * 支付单创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private String updateUser;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


    //支付记录列表
    @TableField(exist = false)
    private List<EquityCouponApplyPaymentRecord> recordList;

}
