package com.rocogz.syy.equity.entity.couponType;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券类型表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:35:33</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_type")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponType extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券类型编号:SERVICE-服务券，OIL_CASH-代金券
     */
    private String code;

    /**
     * 优惠券类型名称
     */
    private String name;

    /**
     * 状态：OPEN-启用、CLOSE-停用
     */
    private String status;


}
