package com.rocogz.syy.equity.dto.equity.statistics;

import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 套餐券/电子油卡券/加油代金券/代驾券 发放统计 查询参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-01-26 11:03:17</dd>
 * <dd>@author：zouzhicai</dd>
 * </dl>
 */
@Data
public class EquityDrivingServiceStatisticsParamDto {

    /************************************ 公共查询条件 start ************************************/
        /**
         * 服务平台
         */
        private List<String> miniAppidList;

        /**
         * 发放主体编号
         */
        private List<String> sourceCodeList;

        /**
         * 报表类型 ALL 汇总报表、DAY 日报、MONTH 月报
         */
        private String reportType;

        /**
         * 当前页数
         */
        private Integer page = 1;

        /**
         * 每页大小
         */
        private Integer limit = 10;
    /************************************ 公共查询条件 end ************************************/

    /************************************  代驾券统计功能查询条件 start ************************************/
        /**
         * 统计类型：P:平台汇总统计，PS:平台+发放主体统计
         */
        private String type;

        /**
         * 开始日期
         * 日报：yyyy-MM-dd
         * 月报：yyyy-MM
         */
        private String startDate;

        /**
         * 结束日期
         */
        private String endDate;
    /************************************  代驾券统计功能查询条件 start ************************************/

    /************************************  列表查询条件 start ************************************/
        /**
         * 编号
         */
        private String code;

        /**
         * 会员编号
         */
        private String userCode;

        /**
         * 会员手机号
         */
        private String mobile;

        /**
         * 根据统计页面点击的日期条件
         * 日报：yyyy-MM-dd
         * 月报：yyyy-MM
         */
        private String searchDate;

        /**
         * 领取开始日期
         */
        private String receiveStartDate;

        /**
         * 领取结束日期
         */
        private String receiveEndDate;

        /**
         * 使用开始日期
         */
        private String useStartDate;

        /**
         * 使用结束日期
         */
        private String useEndDate;

        /**
         * 发券性质
         */
        private String nature;

        /**
         * 优惠券名称
         */
        private String couponName;

    /************************************ 列表查询条件 end ************************************/

}
