package com.rocogz.syy.equity.entity.batchDistributionCouponApplyNode;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 清单工作流待审批、待审核 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-12-16 10:43:52</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_detail_approve")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyDetailApprove extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 节点编号
     */
    private String nodeCode;

    /**
     * 节点类型：APPROVE-审批，AUDIT-审核
     */
    private String nodeType;

    /**
     * 下一个节点编号
     */
    private String nextNodeCode;

    /**
     * 审批人
     */
    private String approveUser;

    /**
     * 状态：UN_START:未开始，PENDING：待审批，END：已结束
     */
    private String status;

    /**
     * 审批时间
     */
    private LocalDateTime approveTime;


}
